#
# confirm.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# reads in the data from all the submitted papers and generates a
# confirmation e-mail to every author.  Set $debug=1 to make sure
# that it works before you run it for real.  Also, edit the text
# here appropriately.  Be sure to hack this program
# so that it sends e-mail "from" you, not me.
#

use usenixDB;

usenixDB::readPaperInfo;

$debug=1;

foreach $id (@usenixDB::ids) {
    $authors = $usenixDB::db{$id}{"Authors"};
    $email = $usenixDB::db{$id}{"Email"};
    $name = $usenixDB::db{$id}{"Name"};
    $title = $usenixDB::db{$id}{"Title"};
    
    if($debug) {
	open(SENDMAIL, ">&STDOUT") || die "Can't dup stdout: $!\n";
	printf SENDMAIL "-------- Start of sendmail session --------\n";
    } else {
	open(SENDMAIL, $usenixDB::sendmailStr) || die "Can't pipe to sendmail: $!\n";
	printf STDOUT "Mailing $email...\n";
    }
	
	printf SENDMAIL <<FOO;
From: Dan Wallach <dwallach\@cs.rice.edu>
To: <$email>
Reply-To: Usenix Security 2001 Chair <sec01chair\@usenix.org>
Subject: UsenixSec2001: your paper submission has been recorded

This is a note to acknowledge that the program committee has received
your submission for publication in the 2001 Usenix Security Symposium.

ID:              $id
Title:           $title
Authors:         $authors
Primary Contact: $name
Contact E-mail:  $email

For any future correspondence you may have regarding your paper,
please reference your paper ID ($id) and direct your e-mail to
<sec01chair\@usenix.org>.

Thanks,

Dan
FOO
    sleep 1 unless $debug;
}
