#
# email-authors.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This is a general-purpose tool for sending e-mail to all your authors.
# It's fairly easy to hack to send to different classifications of authors.
# See notify-authors.pl for sending out your acceptance/rejection notices.
#
use usenixDB;

usenixDB::readPaperInfo;
usenixDB::readPaperStatus;

my $debug=0;

foreach my $id (@usenixDB::ids) {
    my $email = $usenixDB::db{$id}{"Email"};
    my $name = $usenixDB::db{$id}{"Name"};
    my $accept = $usenixDB::db{$id}{"Accepted"};
    
    # gratuitous hack: you can delete the following line or use this
    # as a place to do other clean-up to your mail.  As it's written
    # now, this script only sends e-mail to authors of accepted papers.
    $name = "Kingpin" if $name =~ /^Kingpin/;
    if($accept) {
	$target{"$name <$email>"}++;   # try to remove duplicates
    }
}

foreach $email (sort keys %target) {
    if($debug) {
	open(SENDMAIL, ">&STDOUT") || die "Can't dup stdout: $!\n";
	printf SENDMAIL "-------- Start of sendmail session --------\n";
    } else {
	open(SENDMAIL, $usenixDB::sendmailStr) || die "Can't pipe to sendmail: $!\n";
	printf STDOUT "Mailing $email...\n";
    }
    printf SENDMAIL <<FOO;
From: Dan Wallach <dwallach\@cs.rice.edu>
To: $email
Reply-To: Usenix Security 2001 Chair <sec01chair\@usenix.org>
Subject: UsenixSec2001: camera ready deadline

In my previous message, I had the wrong camera ready deadline.  The
new camera-ready deadline for the 2001 Usenix Security Symposium is
now May 11, 2001.  Once again, detailed author instructions are (or
will soon be) available at the following URL:

    http://www.usenix.org/events/sec01/instrux/

Thanks,

Dan
FOO
    close SENDMAIL;
}
