#
# invite-referees.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This standalone program e-mails your referees to invite them to
# join the PC.  Edit it appropriately.
use usenixDB;
usenixDB::readCommittee;

$debug = 1;

foreach $handle (keys %usenixDB::committee) {
    $email = $usenixDB::committee{$handle}{"E-Mail"};
    $name =  $usenixDB::committee{$handle}{Name};
    
    if($debug) {
	open(SENDMAIL, ">&STDOUT") || die "Can't dup stdout: $!\n";
	printf SENDMAIL "-------- Start of sendmail session --------\n";
    } else {
	open(SENDMAIL, $usenixDB::sendmailStr) || die "Can't pipe to sendmail: $!\n";
	printf STDOUT "Mailing $i...\n";
    }

    printf SENDMAIL <<FOO;
From: Dan Wallach <dwallach\@cs.rice.edu>
To: $name <$email>
Reply-To: Dan Wallach <dwallach\@cs.rice.edu>
Subject: UsenixSec2001 program committee invitation

I have been appointed the chair of the 2001 Usenix Security Symposium,
to be held in Washington, D.C. from August 13-16, 2001.  I would like
to invite you to join the program committee.  Please get back to me as
soon as possible (hopefully before July 27) as I'm operating under a
fairly tight deadline -- the call for papers will be distributed at
this year's Usenix Security Symposium (August 14-17 in Denver).

Following the submission due date, I will divide up the papers in a
semi-random fashion and you will be expected to get your reviews to me
well in advance of the PC meeting.  We'll then get together for one
day to hash out the papers.  I'm proposing to do it here in Houston
[1], although this could change [2].  My proposed date, March 12,
may also change if enough people have problems with it.

Inevitably, a few papers will require shepherding and I may ask you
to help here.  Finally, the conference itself will be in August in
D.C., where I may ask you to be a session chair.

Finally, Usenix will reimburse your travel costs to the PC meeting,
and will also pay for your conference registration.

Relevant dates:

 8 Feb 2001: Papers due
12 Mar 2001: PC meeting (Houston, TX)
23 Mar 2001: Author notification
15 Jun 2001: Camera-ready papers due
13 Aug 2001: Usenix Security Conference (Washington, DC)

If you have any questions, please let me know.

Thanks,

Dan


[1] The weather here in March is beautiful, and Houston is conveniently
    half-way between the coasts.
    
[2] If you would rather we meet somewhere else, I am certainly amenable
    to it, but I would need somebody local (e.g., you) to help with the 
    arrangements.
FOO

    close SENDMAIL;

    sleep 2 unless $debug;
}

