#
# make-review-booklet.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# reads in all reviews, then writes out a directory suitable for
# typing "enscript -2Gr *"
#

use usenixDB;
usenixDB::readReviews;

$outputDir = "summaries";

format OUT =
TITLE:     ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$title
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$title
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$title
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$title
AUTHOR(s): ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$authors
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$authors
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$authors
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$authors
~          ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$authors

.


sub wrapPrintLine {
    my ($prefix, $wrap) = @_;
    my $x = "";
    
    $wrap =~ s/^\s*//;  # nuke leading whitespace
    if ($wrap =~ /^$/) {
	printf OUT "%1s|\n", $prefix;
    } else {
	foreach my $w (split(/ /, $wrap)) {
	    if(length($x) + length($w) + 1 > 78) {
		printf OUT "%1s|%s\n", $prefix,$x;
		$x = $w;
	    } else {
		$x = (length($x)>0)? $x . " " . $w : $w;
	    }
	}
	printf OUT "%1s|%s\n", $prefix,$x if length $x;
    }
}

printf STDERR "Writing files";
foreach $id (@usenixDB::ids) {
    printf STDERR ".";
    $happyId = $id;
    $happyId =~ s/^L//;
    $outputName = sprintf("$outputDir/%03d-summary.txt", $happyId);
    open(OUT, ">$outputName") || die "Can't write $outputName: $!\n";
    
    $title = $usenixDB::db{$id}{Title};
    $authors = $usenixDB::db{$id}{Authors};
    printf OUT "ID:        $id\n";
    write OUT;
    
    printf OUT "REVIEWER   %s\n",
      join("", map {sprintf("%-13s", $_);} @usenixDB::reviewFields);
      
    @reviewers = sort keys %{$usenixDB::reviewDB{$id}{Submitted}};
    
    $counter = 65;  # ASCII for 'A'
    foreach $r (@reviewers) {
	$key{$r} = chr($counter++);  # ASCII characters for 'A' through 'Z'
	printf OUT "%-1s|%-9s%s\n", $key{$r}, $r,
	  join("",
	       map {sprintf("%3.1f          ",
			    $usenixDB::reviewDB{$id}{$_}{$r},
			    $usenixDB::reviewDB{$id}{$_}{$r});}
		 @usenixDB::reviewFields);
    }
    printf OUT "AVERAGE    %s\n", 
      join("",
	   map {sprintf("%3.1f %4.2f    ",
			$usenixDB::reviewDB{$id}{Average}{$_},
			$usenixDB::reviewDB{$id}{Stddev}{$_});}
	   @usenixDB::reviewFields);
	   
    printf OUT "\n";
    foreach $r (@reviewers) {
	foreach $p (@{$usenixDB::reviewDB{$id}{"Public"}{$r}}) {
	    wrapPrintLine($key{$r},$p);
	}
	wrapPrintLine($key{$r}, "----");
	foreach $p (@{$usenixDB::reviewDB{$id}{"Private"}{$r}}) {
	    wrapPrintLine($key{$r},$p);
	}
    }
    close OUT;
}
printf STDERR "\n";
