#
# make-review-forms.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This reads the submitted papers and outputs standard Usenix-style
# review forms, one per file, to $webroot (defined in usenixDB.pm).
#
use usenixDB;

usenixDB::readPaperInfo;

foreach $id (@usenixDB::ids) {
    open(FORM, ">$webroot/$id-review.txt") ||
	die "Can't write $webroot/index.html: $!\n";
	
    $title = $usenixDB::db{$id}{"Title"};
    $authors = $usenixDB::db{$id}{"Authors"};
    $id =~ s/^L//;
    $baseID = sprintf("%03d", $id);
    
    print FORM <<FOO;
# Title: TI    $title
# Author: AU   $authors
# Reviewer: YOUR NAME HERE
# IF YOU (THE REVIEWER) ARE A PROGRAM COMMITTEE MEMBER, REMOVE THIS LINE
#
#       relev   pres    quality overall self-rating
$baseID     1-7     1-7     1-7     1-7     0-3
    <Public comments, each line indented with white space (sent to authors)>
    Please answer the following questions:

    1: Is the work of interest to a reasonable portion of the USENIX
       attendees?  If not, please try and suggest an alternate forum
       for the work.

    2: Does the abstract of the work briefly and clearly state its
       goals and conclusions?

    3: Are the references sufficient?

    4: Is the English use and presentation of this work acceptable?

    5: What are the weakest and/or least understandable parts of the
       work with respect to its presentation?

    6: Is the work technically correct?

    7: What are the weakest technical parts of the work?
       
    8: Do the goals of this work need to be altered, and if so, how?

    9: If you believe that this work should not be accepted, what
       changes would be sufficient for you to change your opinion?

    Please include anything else that you think might be helpful
    to the author here:
    ----
    <Private comments, each line indented with white space>
FOO
}
