#
# make-title-pages.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This reads all the reviews as well as conflicts.txt and outputs
# nice summaries, one per reviewer with conflicts plus one generic
# one (the same output you get from print-review-summary.pl).
#

use usenixDB;

usenixDB::readReviews;
usenixDB::readConflicts;

printf "Writing summaries/title-page.txt\n";
open(OUT, ">summaries/title-page.txt") || die "can't write summaries/title-page.txt: $!\n";
usenixDB::printSummary OUT;
close OUT;

foreach $r (sort keys %usenixDB::conflicts) {
    $f = "summaries/title-page-$r.txt";
    printf "Writing $f\n";
    open(OUT, ">$f") || die "Can't write $f: $!\n";
    usenixDB::printSummary OUT $r;
    close OUT;
}
