#
# make-web.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This reads the submitted papers and outputs index.html and
# abstracts.html to $webroot.  A reference is made to "everything.tar.gz"
# that you're going to have to generate separately.  You should
# also set up HTTP basic-auth protection (or whatever) on the Web page.
#
use usenixDB;

usenixDB::readPaperInfo;

open(ABBREV, ">$webroot/index.html") || die "Can't write $webroot/index.html: $!\n";
open(VERBOSE, ">$webroot/abstracts.html") || die "Can't write $webroot/index.html: $!\n";

print ABBREV <<FOO;
<html>
<head>
<title>UsenixSec2001: Paper Submissions</title>
</head>

<body bgcolor="#f5e3bd" text="#000000">
<font face="helvetica,geneva,arial">

<h1>UsenixSec2001: Paper Submissions</h1>

<a href="abstracts.html">also available with abstracts</a>
<p>
<a href="everything.tar.gz">everything.tar.gz</a> (~13MB)
<p>
<table border width="100%">
<tr>
<td bgcolor="#f5cf98">ID</td>
<td bgcolor="#f5cf98">Title</td>
<td bgcolor="#f5cf98">Authors</td>
<td bgcolor="#f5cf98">Review</td>
</tr>
FOO
    
    print VERBOSE <<FOO;
<html>
<head>
<title>UsenixSec2001: Paper Submissions + Abstracts</title>
</head>

<body bgcolor="#f5e3bd" text="#000000">
<font face="helvetica,geneva,arial">

<h1>UsenixSec2001: Paper Submissions + Abstracts</h1>

<table border width="100%">
<tr>
<td bgcolor="#f5cf98">ID</td>
<td bgcolor="#f5cf98">Title</td>
<td bgcolor="#f5cf98">Authors</td>
<td bgcolor="#f5cf98">Review</td>
</tr>
FOO

foreach $id (@usenixDB::ids) {
    $authors = $usenixDB::db{$id}{"Authors"};
    $title = $usenixDB::db{$id}{"Title"};
    $abstract = $usenixDB::db{$id}{"Abstract"};
    
    print ABBREV "<tr><td>$id</td><td><a href=\"${id}.pdf\">$title</a></td><td>$authors</td><td><a href=\"${id}-review.txt\">form</a></tr>\n";
    print VERBOSE "<tr><td rowspan=2>$id</td><td><a href=\"${id}.pdf\">$title</a></td><td>$authors</td><td><a href=\"${id}-review.txt\">form</a></tr>\n";
    print VERBOSE "<tr><td colspan=2>$abstract</td></tr>\n";
}

print ABBREV "</table></body></html>\n";
print VERBOSE "</table></body></html>\n";
