#
# notify-authors.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# When it's all over, the sends the authors e-mail telling them
# the fate of their paper. You're going to want to hack the script
# to send e-mail from you intead of from me.
#
use usenixDB;

usenixDB::readPaperInfo;
usenixDB::readReviews;
usenixDB::readCommittee;
usenixDB::readPaperStatus;

my $debug=0;

sub printRefereeComments {
    my ($out, $id) = @_;
    
    my $happyId = $id;
    $happyId =~ s/^L//;
    
    my $title = $usenixDB::db{$id}{Title};
    my $authors = $usenixDB::db{$id}{Authors};
    
    my @reviewers = sort keys %{$usenixDB::reviewDB{$id}{Submitted}};
    
    my $num=1;
    foreach my $r (@reviewers) {
	printf $out "\n========== Review #%d\n", $num++;
	foreach my $p (@{$usenixDB::reviewDB{$id}{"Public"}{$r}}) {
	    printf $out "%s\n", $p;
	}
    }
}

foreach my $id (@usenixDB::ids) {
    my $authors = $usenixDB::db{$id}{"Authors"};
    my $email = $usenixDB::db{$id}{"Email"};
    my $name = $usenixDB::db{$id}{"Name"};
    my $title = $usenixDB::db{$id}{"Title"};
    my $accept = $usenixDB::db{$id}{"Accepted"};
    my $shepherd = $usenixDB::db{$id}{"Shepherd"};
    
    if($debug) {
	open(SENDMAIL, ">&STDOUT") || die "Can't dup stdout: $!\n";
	printf SENDMAIL "-------- Start of sendmail session --------\n";
    } else {
	open(SENDMAIL, $usenixDB::sendmailStr) || die "Can't pipe to sendmail: $!\n";
	printf STDOUT "Mailing $email...\n";
    }
	
    my $shepString = "";
    my $shepName = "";
    my $shepEmail = "";
    my $shepCC="";
    if($shepherd) {
	$shepName=$usenixDB::committee{$shepherd}{"Name"};
	$shepEmail=$usenixDB::committee{$shepherd}{"E-Mail"};
	$shepCC="Cc: $shepName <$shepEmail>\n";
	$shepString=<<FOO;

Your paper is being shepherded by $shepName <$shepEmail>,
who you should contact after reading this message.  Your
shepherd and you will work out a schedule whereby you make
the changes requested by the committee.  Keep in mind that your
shepherd has the power to reject your paper if you do not
make the requested changes.
FOO
    }
    
    if($accept) {
	printf SENDMAIL <<FOO;
From: Dan Wallach <dwallach\@cs.rice.edu>
To: <$email>
Reply-To: Usenix Security 2001 Chair <sec01chair\@usenix.org>
FOO
        printf SENDMAIL $shepCC;
	printf SENDMAIL <<FOO;
Subject: UsenixSec2001: paper $id has been accepted

Congratulations!  Your paper ($id) has been accepted for publication
in the 2001 Usenix Security Symposium.

ID:              $id
Title:           $title
Authors:         $authors
Primary Contact: $name
Contact E-mail:  $email
FOO
        printf SENDMAIL $shepString;
	printf SENDMAIL <<FOO;

THE FINAL CAMERA-READY DEADLINE IS MAY 2, 2001.  Instructions for
preparing your paper are (or will shortly be) here:
    
    http://www.usenix.org/events/sec01/instrux/
  
Thanks,

Dan

FOO
	printRefereeComments(SENDMAIL, $id);
    } else {
	printf SENDMAIL <<FOO;
From: Dan Wallach <dwallach\@cs.rice.edu>
To: <$email>
Reply-To: Usenix Security 2001 Chair <sec01chair\@usenix.org>
Subject: UsenixSec2001: paper $id

I regret to inform you that your paper
    
    ($id) $title 

has not been accepted for publication in the 2001 Usenix Security
Symposium.  The reviews of your paper are attached below.

Despite this news, we hope you will participate in the the Usenix
Security Symposium as it promises to be a very interesting conference.
All the neccesary information is (or will shortly appear) on the
conference Web page:

    http://www.usenix.org/events/sec01/

Sincerely,

Dan Wallach
Program Chair, 2001 Usenix Security Symposium

FOO
	printRefereeComments(SENDMAIL, $id);
    }
    sleep 1 unless $debug;
}
