#
# print-assignments.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# Edit assignments.txt to have the referees after every line.
# So, if an original line said: "L78: I, Robot".  You'd add a line
# afterward saying "L78=heinlein,niven,jms" to assign the review.
# This program reads assignments.txt and prints out, for each
# referee, what papers have been assigned (along with the total
# number of assigned papers).  It ignores all lines except those
# saying "L...=user,user,user".
#
# Running this program in one window while tweaking assignments.txt
# in another window is a nice iterative process to help you balance
# out the referee assignments.
#
# TODO: add some checks to catch papers that haven't been assigned
# any reviews.
#
    
use strict;
use usenixDB;

usenixDB::readAssignments;

foreach my $reviewer (sort keys %usenixDB::numReviews) {
    my @ids = @{$usenixDB::reviewerToID{$reviewer}};
    printf "%10s (%2s): %s\n", $reviewer, $usenixDB::numReviews{$reviewer},
	join(" ", sort { $a <=> $b } map { s/^L//; $_; } @ids);
}
