#
# print-paper-status.pl
# Dan Wallach <dwallach@cs.rice.edu>
#
# This is really just a pretty-printer for paper-status.txt,
# the file that you create to list what papers you've accepted
# and what sessions they're going in.  It's also helpful to catch
# typos.  It would be awfully embarassing if a typo caused you to
# accept a wrong paper.
#
use usenixDB;

usenixDB::readCommittee;
usenixDB::readPaperStatus;
usenixDB::readPaperInfo;

$num=1;
foreach (@usenixDB::sessions) {
    printf "Session   %d (%s)\n", $num++, ${$_}{Session};
    printf "  IT:     %s\n", ${$_}{IT};
    printf "  Chair:  %s\n", $usenixDB::committee{${$_}{Chair}}{Name};
    printf "  Papers: ";

    printf "%s\n\n", join "\n          ",
      map {sprintf "(%3s) %s", $_, substr($usenixDB::db{$_}{"Title"}, 0, 63);}
	split(/ /, ${$_}{Papers});
}
