// sweep2.cpp  -  generated by Sonic/C++ translator v 0.907.
// Translator written by Don Cross <dcross@intersrv.com>
// For more info about Sonic, see the following web site:
// http://www.intersrv.com/~dcross/sonic/

// This file created: Wed Mar 27 01:16:23 2002

// Standard includes...
#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Sonic-specific includes...
#include "sonic.h"


const long    SamplingRate     =  44100;
const double  SampleTime       =  1.0 / double(SamplingRate);
const int     NumChannels      =  2;
const int     InterpolateFlag  =  1;

const double pi = 4.0 * atan(1.0);
const double e  = exp(1.0);

void f_sweep2 (
    SonicWave &v_outWave,
    double v_time,
    double v_ampl,
    double v_minFreq,
    double v_maxFreq,
    double v_warbleFAmp,
    double v_warbleFFreq );


int main ( int argc, char *argv[] )
{
    if ( argc != 8 )
    {
        cerr << "Use:  sweep2 outWave time ampl minFreq maxFreq warbleFAmp warbleFFreq" << endl << endl;
        return 1;
    }

    SonicWave v_outWave ( argv[1], "outWave", SamplingRate, NumChannels );
    double v_time = ScanReal ( "time", argv[2] );
    double v_ampl = ScanReal ( "ampl", argv[3] );
    double v_minFreq = ScanReal ( "minFreq", argv[4] );
    double v_maxFreq = ScanReal ( "maxFreq", argv[5] );
    double v_warbleFAmp = ScanReal ( "warbleFAmp", argv[6] );
    double v_warbleFFreq = ScanReal ( "warbleFFreq", argv[7] );

    f_sweep2 ( v_outWave, v_time, v_ampl, v_minFreq, v_maxFreq, v_warbleFAmp, v_warbleFFreq );

    v_outWave.convertToWav ( argv[1] );
    SonicWave::EraseAllTempFiles();
    return 0;
}


void f_sweep2 (
    SonicWave &v_outWave,
    double v_time,
    double v_ampl,
    double v_minFreq,
    double v_maxFreq,
    double v_warbleFAmp,
    double v_warbleFFreq )
{
    double v_theta = 0;
    double v_fix = 0;

    v_fix = 2*pi/SamplingRate;
    {
        //  outWave[c,i:time*r] = ampl*sin(fix*i*(minFreq + (maxFreq - minFreq)*i/(time*2*r) + warbleFAmp*sin(fix*i*warbleFFreq)));

        v_outWave.openForWrite();
        double sample [NumChannels];
        double t = double(0);
        const long numSamples = long(v_time*SamplingRate);
        for ( long i=0; i < numSamples; ++i, t += SampleTime )
        {
            sample[0] = v_ampl*sin(v_fix*i*(v_minFreq + (v_maxFreq - v_minFreq)*i/(v_time*2*SamplingRate) + v_warbleFAmp*sin(v_fix*i*v_warbleFFreq)));
            sample[1] = v_ampl*sin(v_fix*i*(v_minFreq + (v_maxFreq - v_minFreq)*i/(v_time*2*SamplingRate) + v_warbleFAmp*sin(v_fix*i*v_warbleFFreq)));
            v_outWave.write ( sample );
        }
        v_outWave.close();
    }
}



/*---  end of file sweep2.cpp  ---*/
