function zigzag(x:real): real {
    var fix: real;
    var almost:real;
    fix = x / (2*pi);
    fix = 2*(fix - floor(fix));
    if(fix <= 1) almost = fix;
    else almost=2-fix;

    return 2*(almost - 0.5);
}

program sweep3(
  outLeft: wave,
  outRight: wave,
  outStereo: wave,
  time: real,
  ampl: real,
  minFreq: real,
  maxFreq: real,
  warbleFAmp: real,
  warbleFFreq: real,
) {
    var theta : real;
    var fix : real;

    fix = (2 * pi) / r;
    

    outStereo[c, i:time*r] = ampl * sin(fix * i *
			 (minFreq +
			  (((maxFreq - minFreq)*i)/(time*2*r))) +
			 (warbleFAmp * sin(fix * i * warbleFFreq))
			  // warbleFAmp * zigzag(fix * i * warbleFFreq)
			 );
    outLeft[c, i:time*r] = {outStereo[c, i], 0};
    outRight[c, i:time*r] = {0, outStereo[c, i]};
}
