// sweep3.cpp  -  generated by Sonic/C++ translator v 0.907.
// Translator written by Don Cross <dcross@intersrv.com>
// For more info about Sonic, see the following web site:
// http://www.intersrv.com/~dcross/sonic/

// This file created: Wed Mar 27 08:52:56 2002

// Standard includes...
#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Sonic-specific includes...
#include "sonic.h"


const long    SamplingRate     =  44100;
const double  SampleTime       =  1.0 / double(SamplingRate);
const int     NumChannels      =  2;
const int     InterpolateFlag  =  1;

const double pi = 4.0 * atan(1.0);
const double e  = exp(1.0);

void f_sweep3 (
    SonicWave &v_outLeft,
    SonicWave &v_outRight,
    SonicWave &v_outStereo,
    double v_time,
    double v_ampl,
    double v_minFreq,
    double v_maxFreq,
    double v_warbleFAmp,
    double v_warbleFFreq );

double f_zigzag (
    double v_x );


int main ( int argc, char *argv[] )
{
    if ( argc != 10 )
    {
        cerr << "Use:  sweep3 outLeft outRight outStereo time ampl minFreq maxFreq warbleFAmp warbleFFreq" << endl << endl;
        return 1;
    }

    SonicWave v_outLeft ( argv[1], "outLeft", SamplingRate, NumChannels );
    SonicWave v_outRight ( argv[2], "outRight", SamplingRate, NumChannels );
    SonicWave v_outStereo ( argv[3], "outStereo", SamplingRate, NumChannels );
    double v_time = ScanReal ( "time", argv[4] );
    double v_ampl = ScanReal ( "ampl", argv[5] );
    double v_minFreq = ScanReal ( "minFreq", argv[6] );
    double v_maxFreq = ScanReal ( "maxFreq", argv[7] );
    double v_warbleFAmp = ScanReal ( "warbleFAmp", argv[8] );
    double v_warbleFFreq = ScanReal ( "warbleFFreq", argv[9] );

    f_sweep3 ( v_outLeft, v_outRight, v_outStereo, v_time, v_ampl, v_minFreq, v_maxFreq, v_warbleFAmp, v_warbleFFreq );

    v_outLeft.convertToWav ( argv[1] );
    v_outRight.convertToWav ( argv[2] );
    v_outStereo.convertToWav ( argv[3] );
    SonicWave::EraseAllTempFiles();
    return 0;
}


void f_sweep3 (
    SonicWave &v_outLeft,
    SonicWave &v_outRight,
    SonicWave &v_outStereo,
    double v_time,
    double v_ampl,
    double v_minFreq,
    double v_maxFreq,
    double v_warbleFAmp,
    double v_warbleFFreq )
{
    double v_theta = 0;
    double v_fix = 0;

    v_fix = 2*pi/SamplingRate;
    {
        //  outStereo[c,i:time*r] = ampl*sin(fix*i*(minFreq + (maxFreq - minFreq)*i/(time*2*r) + warbleFAmp*zigzag(fix*i*warbleFFreq)));

        v_outStereo.openForWrite();
        double sample [NumChannels];
        double t = double(0);
        const long numSamples = long(v_time*SamplingRate);
        for ( long i=0; i < numSamples; ++i, t += SampleTime )
        {
	    double freq1, freq2, freq3;
	    freq1 = v_minFreq;
	    freq2 = (v_maxFreq - v_minFreq)*(double)i/(v_time*(double)SamplingRate);
	    freq3 = v_warbleFAmp*f_zigzag(v_fix*(double)i*v_warbleFFreq);
            sample[0] = v_ampl*sin(v_fix*i*(freq1 + freq2 + freq3));
            sample[1] = v_ampl*sin(v_fix*i*(freq1 + freq2 + freq3));
            v_outStereo.write ( sample );

#ifndef QUIET
	    printf("%6d: %.3f %.3f %.3f (%.3f * %.3f => %.3f) %.4f\n", i, freq1, freq2, freq3, (freq1 + freq2 + freq3), v_fix * i, v_fix*i*(freq1 + freq2 + freq3), sample[0]);
#endif
        }
        v_outStereo.close();
    }
    {
        //  outLeft[c,i:time*r] = { outStereo[c,i], zigzag(fix*i*warbleFFreq) };

        v_outLeft.openForWrite();
        v_outStereo.openForRead();
        double sample [NumChannels];
        double t = double(0);
        const long numSamples = long(v_time*SamplingRate);
        for ( long i=0; i < numSamples; ++i, t += SampleTime )
        {
            int countdown;
            sample[0] = v_outStereo.fetch(0, i, countdown);
            sample[1] = f_zigzag(v_fix*i*v_warbleFFreq);
            v_outLeft.write ( sample );
        }
        v_outLeft.close();
        v_outStereo.close();
    }
    {
        //  outRight[c,i:time*r] = { 0, outStereo[c,i] };

        v_outRight.openForWrite();
        v_outStereo.openForRead();
        double sample [NumChannels];
        double t = double(0);
        const long numSamples = long(v_time*SamplingRate);
        for ( long i=0; i < numSamples; ++i, t += SampleTime )
        {
            int countdown;
            sample[0] = 0;
            sample[1] = v_outStereo.fetch(1, i, countdown);
            v_outRight.write ( sample );
        }
        v_outRight.close();
        v_outStereo.close();
    }
}


double f_zigzag (
    double v_x )
{
    double v_fix = 0;
    double v_almost = 0;

    v_fix = v_x/(2*pi);
    v_fix = 2*(v_fix - floor(v_fix));
    if ( v_fix <= 1 )
        v_almost = v_fix;
    else
        v_almost = 2 - v_fix;

    return 2*(v_almost - 0.5);
}



/*---  end of file sweep3.cpp  ---*/
