#
# Copyright (c) 2011, EPFL (Ecole Politechnique Federale de Lausanne)
# All rights reserved.
#
# Created by Marco Canini, Daniele Venzano, Dejan Kostic, Jennifer Rexford
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   -  Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#   -  Redistributions in binary form must reproduce the above copyright notice,
#      this list of conditions and the following disclaimer in the documentation
#      and/or other materials provided with the distribution.
#   -  Neither the names of the contributors, nor their associated universities or
#      organizations may be used to endorse or promote products derived from this
#      software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
# SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

from of_command import OpenflowCommand

import utils


PKTI_VN = -1

class FlowTableModificationMessage(OpenflowCommand):
	""" See openflow spec section 5.6 """
# X-CHANGE
	def __init__(self, command, arguments={}, vn = PKTI_VN, wait_bit = False, next_entry_attr = {}, next_entry_vn = PKTI_VN):
		
		OpenflowCommand.__init__(self)
		self.command = command
		self.arguments = arguments
# X-CHANGE
		self.vn = vn
		self.wait_bit = wait_bit
		self.next_entry_attr = next_entry_attr
		self.next_entry_vn = next_entry_vn

	def __repr__(self):
		s = "FlowTableModificationMessage(" + repr(self.__dict__) + ")"
		return s

	def __getstate__(self):
		filtered_dict = OpenflowCommand.__getstate__(self)
		filtered_dict["command"] = self.command
		filtered_dict["arguments"] = utils.serialize_dict(self.arguments)

# X-CHANGE
		filtered_dict["vn"] = self.vn
		filtered_dict["wait_bit"] = self.wait_bit
		filtered_dict["next_entry_attr"] = self.next_entry_attr
		filtered_dict["next_entry_vn"] = self.next_entry_vn
		return filtered_dict

