from multiprocessing.queues import JoinableQueue
import errno

def retry_on_eintr(function, *args, **kw):
	while True:
		try:
			return function(*args, **kw);
		except IOError, e:
			if e.errno == errno.EINTR:
				print ""
				print "retry JoinableQueue.get()"
				print ""
				continue
			else:
				raise

class ReQueue(JoinableQueue):
	def get(self, block=True, timeout=None):
		return retry_on_eintr(JoinableQueue.get, self)
