
from se_dict import SeDict
from symbolic.instrumentation import whichBranch
python_ord = ord

def se_ord(obj):
    __foo = hasattr(obj, """__ord__""")
    if __foo:
        whichBranch(True)
        return obj.__ord__()
    else:
        whichBranch(False)
        return python_ord(obj)
ord = se_ord
import nox.lib.openflow as openflow
IN_PORT = """in_port"""
AP_SRC = """ap_src"""
AP_DST = """ap_dst"""
DL_SRC = """dl_src"""
DL_DST = """dl_dst"""
DL_VLAN = """dl_vlan"""
DL_VLAN_PCP = """dl_vlan_pcp"""
DL_TYPE = """dl_type"""
NW_SRC = """nw_src"""
NW_SRC_N_WILD = """nw_src_n_wild"""
NW_DST = """nw_dst"""
NW_DST_N_WILD = """nw_dst_n_wild"""
NW_PROTO = """nw_proto"""
NW_TOS = """nw_tos"""
TP_SRC = """tp_src"""
TP_DST = """tp_dst"""
GROUP_SRC = """group_src"""
GROUP_DST = """group_dst"""
N_TABLES = """n_tables"""
N_BUFFERS = """n_bufs"""
CAPABILITES = """caps"""
ACTIONS = """actions"""
PORTS = """ports"""
PORT_NO = """port_no"""
SPEED = """speed"""
CONFIG = """config"""
STATE = """state"""
CURR = """curr"""
ADVERTISED = """advertised"""
SUPPORTED = """supported"""
PEER = """peer"""
HW_ADDR = """hw_addr"""
CONTINUE = 0
STOP = 1

class Component:

    def __init__(self, ctxt):
        self.ctxt = ctxt
        self.packet_in_cb = None
        self.datapath_leave_cb = None
        self.datapath_join_cb = None

    def register_for_packet_in(self, func):
        self.packet_in_cb = func

    def register_for_port_stats_in(self, func):
        self.port_stats_in_cb = func

    def register_for_datapath_leave(self, func):
        self.datapath_leave_cb = func

    def register_for_datapath_join(self, func):
        self.datapath_join_cb = func

    def post_callback(self, timeout, func):
        if (self.ctxt != None):
            whichBranch(True)
            self.ctxt.post_callback(timeout, func)
        else:
            whichBranch(False)

    def send_openflow(self, dp_id, buffer_id, packet, actions, inport=openflow.OFPP_CONTROLLER):
        if (self.ctxt != None):
            whichBranch(True)
            self.ctxt.send_openflow(dp_id, buffer_id, packet, actions, inport)
        else:
            whichBranch(False)

    def install_datapath_flow(self, dp_id, attrs, idle_timeout, hard_timeout, actions, buffer_id=None, priority=openflow.OFP_DEFAULT_PRIORITY, inport=None, packet=None):
        if (self.ctxt != None):
            whichBranch(True)
            self.ctxt.install_datapath_flow(dp_id, attrs, idle_timeout, hard_timeout, actions, buffer_id, priority, inport, packet)
        else:
            whichBranch(False)

    def __getstate__(self):
        return SeDict({})