
from se_dict import SeDict
from symbolic.instrumentation import whichBranch
python_ord = ord

def se_ord(obj):
    __foo = hasattr(obj, """__ord__""")
    if __foo:
        whichBranch(True)
        return obj.__ord__()
    else:
        whichBranch(False)
        return python_ord(obj)
ord = se_ord
from symbolic.symbolic_types import SymbolicMacAddress, SymbolicInteger, SymbolicType

class ethernet:
    IP_TYPE = 2048
    ARP_TYPE = 2054
    RARP_TYPE = 32821
    VLAN_TYPE = 33024
    LLDP_TYPE = 35020
    PAE_TYPE = 34958

    def __init__(self, name):
        """ name is the name of ethernet symbolic variable """
        self.name = name
        self.parsed = True
        self.src = SymbolicMacAddress((name + """#src"""))
        self.dst = SymbolicMacAddress((name + """#dst"""))
        self.type = SymbolicInteger((name + """#packet_type"""), 16)
        self.arr = None
        self.next = None

    def __hash__(self):
        return hash(self.name)

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return (((((((self.name + """(src=""") + str(self.src)) + """, dst=""") + str(self.dst)) + """, type=""") + str(self.type)) + """)""")

    def __ne__(self, other):
        __se_tmp_1 = isinstance(other, ethernet)
        if (not __se_tmp_1):
            whichBranch(True)
            return True
        else:
            whichBranch(False)
            raise NotImplementedError

    def __eq__(self, other):
        __se_tmp_2 = isinstance(other, ethernet)
        if (not __se_tmp_2):
            whichBranch(True)
            return False
        else:
            whichBranch(False)
            raise NotImplementedError

    def __getstate__(self):
        filtered_dict = SeDict({})
        filtered_dict["""name"""] = self.name
        filtered_dict["""src"""] = self.src.__getstate__()
        filtered_dict["""dst"""] = self.dst.__getstate__()
        filtered_dict["""type"""] = self.type.__getstate__()
        return filtered_dict

    def getConcrValue(self):
        dd = dict()
        for k in self.__dict__:
            __se_tmp_3 = isinstance(self.__dict__[k], SymbolicType)
            if __se_tmp_3:
                whichBranch(True)
                dd[k] = self.__dict__[k].getConcrValue()
            else:
                whichBranch(False)
                dd[k] = self.__dict__[k]
        return dd