#
# Copyright (c) 2011, Richard Wang
# All rights reserved.
#
# Created by Richard Wang
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   -  Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#   -  Redistributions in binary form must reproduce the above copyright notice,
#      this list of conditions and the following disclaimer in the documentation
#      and/or other materials provided with the distribution.
#   -  Neither the names of the contributors, nor their associated universities or
#      organizations may be used to endorse or promote products derived from this
#      software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
# SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

# ==========================================
# Author: Richard Wang
# Contact: rwthree@princeton.edu
#
# 1. Parses Alpha File 
# 2. Determine Wildcard Rules
# ==========================================


import Alphas
import Bins
import Globals
import IPRules

import IPTransition # DELETE LATER TODO

#class EvalRules:
#    def __init__(self):
#	self.IPNumBits = 0
#	self.IPBins = None
#	self.IPRules = None

def updateAlphas():
    oldTargetRules = copyTargets(Globals.TARGETRULES)      
    oldInstallRules = copyTargets(Globals.INSTALLEDRULES) 

    newAlphas = Alphas.getAlphas(Globals.ALPHAFILE)
    Globals.log.info("NEW ALPHAS " + str(newAlphas))
    Globals.log.info("OLD ALPHAS" + str(Globals.ALPHAS))
    (oldTargetList, newTargetList) = Bins.determineTargets(oldTargetRules, Globals.ALPHAS, oldInstallRules)
    (oldTargetList, newTargetList) = Bins.redistributeTargets(oldTargetRules, Globals.ALPHAS, newAlphas, oldTargetList, newTargetList)
#    Bins.printTargetList(newTargetList)
    totalAssignments = len(newTargetList)
    Globals.log.info("Total Assigns: " + str(totalAssignments))

    newAlphas = Alphas.distributeAlphas(newAlphas, Globals.ALPHAS, totalAssignments)
    Globals.log.info("DISTRIBUTE NEW ALPHAS " + str(newAlphas))
    newAlphas = Alphas.distributeEven(newAlphas, totalAssignments)
#    newAlphas = Alphas.distributeOld(newAlphas, Globals.ALPHAS, totalAssignments)
    Globals.log.info("DISTRIBUTE OLD ALPHAS " + str(newAlphas))
    newAlphas = Alphas.distributeRemaining(newAlphas, totalAssignments)
    Globals.log.info("REMAINING NEW ALPHAS " + str(newAlphas))
    Alphas.updateAlphas(newAlphas, oldTargetList)

    newTargetList = IPRules.assignReplicas(newAlphas, newTargetList)
    Bins.printTargetList(newTargetList)

    newRuleList = IPRules.getNewRules(Globals.TARGETRULES, newTargetList)
    IPRules.printRules(newRuleList)

#    (oldRules, newRules) = IPRules.redistributeRules(Globals.TARGETRULES, Globals.ALPHAS, newAlphas)
#    newRuleList.extend(newRules)

#    IPRules.updateAssigns(newRuleList, oldRules)
    IPRules.updateAssigns(newRuleList)
    Alphas.printAlphas(Globals.ALPHAS)

    return newRuleList

def copyTargets(targetList):
    copyList = []
    for i in range(0, len(targetList)):
        copyList.append({'ip': targetList[i]['ip'], 'wild': targetList[i]['wild'], 'replica': targetList[i]['replica'], 'traffic': targetList[i]['traffic']})
    return copyList

def copyAlphas(alphaList):
    copyList = []
    for i in range(0, len(alphaList)):
        copyList.append({'replica': alphaList[i]['replica'], 'alphaTarget': alphaList[i]['alphaTarget'], 'alphaAssign': alphaList[i]['alphaAssign']})
    return copyList
