# Copyright 2008 (C) Nicira, Inc.
# 
# This file is part of NOX.
# 
# NOX is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# NOX is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with NOX.  If not, see <http://www.gnu.org/licenses/>.
import array
from nox.lib.packet.ethernet import *
from nox.netapps.tests import unittest

pyunit = __import__('unittest')

large_udp = \
"""\
\xff\xff\xff\xff\xff\xff\x00\x1d\x09\x21\x7f\x14\x08\x00\x45\x00\
\x02\x40\x00\x00\x00\x00\x40\x11\x78\xae\x00\x00\x00\x00\xff\xff\
\xff\xff\x00\x44\x00\x43\x02\x2c\x5e\xe2\x01\x01\x06\x00\x95\x14\
\xf7\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x1d\x09\x21\x7f\x14\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x63\x82\x53\x63\x35\x01\x01\x3d\x07\x01\
\x00\x1d\x09\x21\x7f\x14\x3c\x06\x75\x64\x68\x63\x70\x20\x37\x07\
\x01\x03\x06\x0c\x0f\x1c\x2c\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
"""


class UDPTestCase(unittest.NoxTestCase):

    def getInterface(self):
        return str(UDPTestCase)    

    def setUp(self):
        pass 
 
    def tearDown(self):
        pass

    def fullUDPPacket(self):    
        eth = ethernet(array('B',large_udp))   
        udph = eth.find('udp')
        iph  = eth.find('ipv4')
        assert(udph)
        assert(iph)
        assert(udph.srcport == 68)
        assert(udph.dstport == 67)
        assert(udph.len     == 556)
        assert(udph.csum    == 0x5ee2)
        assert(udph.checksum() == udph.csum)
        assert(len(udph.payload) == udph.len - 8)
        assert(udph.tostring() == large_udp[34:] )
        dhcph = eth.find('dhcp')

        assert(dhcph)
        assert(dhcph.op    == 1)
        assert(dhcph.htype == 1)
        assert(dhcph.hlen  == 6)
        assert(dhcph.hops  == 0)
        assert(dhcph.xid   == 0x9514f72d)
        assert(dhcph.secs  == 0)
        assert(dhcph.flags == 0)
        assert(dhcph.ciaddr == 0)
        assert(dhcph.yiaddr == 0)
        assert(dhcph.siaddr == 0)
        assert(dhcph.giaddr == 0)
        assert(array_to_octstr(dhcph.chaddr[:6]) == '00:1d:09:21:7f:14')
        assert(len(dhcph.parsedOptions.keys()) == 4)

def suite(ctxt):
    suite = pyunit.TestSuite()
    suite.addTest(UDPTestCase("fullUDPPacket", ctxt))
    return suite
