#! /bin/sh
ps aux | grep ovs | awk '{print $2}' | xargs kill -9
# terminate the controller that using tcp port 6633, This will kill any existing TCP connection, using this port.
fuser -k 6633/tcp
kill `cd /usr/local/var/run/openvswitch && cat ovsdb-server.pid ovs-vswitchd.pid`
sudo rmmod openvswitch
sudo rm /usr/local/etc/openvswitch/conf.db
# install openvswitch
./boot.sh
./configure --with-linux=/lib/modules/`uname -r`/build
make
make install
# start openvswitch
insmod datapath/linux/openvswitch.ko
mkdir -p /usr/local/etc/openvswitch
ovsdb-tool create /usr/local/etc/openvswitch/conf.db vswitchd/vswitch.ovsschema
ovsdb-server         --remote=punix:/usr/local/var/run/openvswitch/db.sock \
                     --remote=db:Open_vSwitch,manager_options \
                     --private-key=db:SSL,private_key \
                     --certificate=db:SSL,certificate \
                     --bootstrap-ca-cert=db:SSL,ca_cert \
                     --pidfile --detach
ovs-vsctl --no-wait init
ovs-vswitchd --pidfile --detach

mn -c
