
/**
 * Interface for a bounded buffer.
 * @author Mathias Ricken
 */
public interface IBoundedBuffer<T> {
    /**
     * Write an item into the bounded buffer. Waits until an entry is available.
     * @param item item to write
     * @throws InterruptedException
     */
    public void write(T item) throws InterruptedException;

    /**
     * Read an item from the bounded buffer. Waits until an entry is available.
     * @return item read
     * @throws InterruptedException
     */
    public T read() throws InterruptedException;
}