/**
 * COMP 402 Homework #01
 * Symbolic Boolean Expressions
 */

/** Symbolic boolean expression representation */
sealed abstract class BoolExp
// Literal Cases
case class Val(v : Boolean) extends BoolExp
case class Var(id : String) extends BoolExp
// Unary Operator Cases
case class Not(exp : BoolExp) extends BoolExp
// Binary Operator Cases
case class And(lhs : BoolExp, rhs : BoolExp) extends BoolExp
case class Or(lhs : BoolExp, rhs : BoolExp) extends BoolExp
case class Implies(lhs : BoolExp, rhs : BoolExp) extends BoolExp
// Ternary Operator Cases
case class If(test : BoolExp, conseq : BoolExp, alt : BoolExp) extends BoolExp

object BoolExp {
  
  /** Internal representation for if expressions */
  sealed abstract class IfExp
  // Cases
  case class IVal(v : Boolean) extends IfExp
  case class IVar(id : String) extends IfExp
  case class IIf(test : IfExp, conseq : IfExp, alt : IfExp) extends IfExp

  // Convenience declarations for boolean constants
  // ! Scala convention is to capitalize the first letter for a constant
  // ! Such (capitalized) identifiers are treated as constants in match patterns
  val True = IVal(true)
  val False = IVal(false)
  
  /**
   * Convert boolean expressions to internal
   * if-representation for further processing
   */
  def convertToIf(exp : BoolExp) : IfExp = null

  /**
   * Normalize the if-representation form of the
   * given expression by making all condition-slots simple
   * (i.e. IIf-test can only be IVal or IVar)
   */
  def normalize(exp : IfExp) : IfExp = null

  /**
   * Perform head normalization
   * (Helper for normalize)
   */
  def headNormalize(test : IfExp, conseq : IfExp, alt : IfExp) : IfExp = null

  /**
   * Perform symbolic evaluation on the given expression
   * (i.e. simplify out tautologies, contradictions, etc.)
   */
  def eval(exp : IfExp, env : Map[String,Boolean]) : IfExp = null

  /**
   * Convert if-representation back to normal
   * Maps several if-forms onto more concise boolean expressions
   */
  def convertToBool(exp : IfExp) : BoolExp = null
}

