import java.util.LinkedList;

/** Interface for a ReaderWriterLock. */
public interface IReaderWriterLock {
  /** Must be called by each reader thread before starting to read.  The calling method must <i>not</i> be 
    * synchronized.  This method blocks the reader if there are current active or waiting writers, until those 
    * writers have finished.
    * @throws IllegalStateException if the thread is already a reader or writer
    */
  public void startRead();

  /** Must be called by each reader thread after it is finished reading.  The calling method must <i>not</i> be 
    * synchronized. This method wakes up a waiting writer if there are no remaining reader threads actively reading. 
    * @throws IllegalStateException if the thread is already a reader or writer
    */
  public void endRead();
  
  /** Must be called by each writer thread before starting to write.  The calling method must <i>not</i> be 
    * synchronized. This method blocks the writer if there are any active readers or writers, and prevents any new 
    * readers from starting to read until this writer gets a chance to write.
    * @throws IllegalStateException if the thread is already a reader or writer
    */
  public void startWrite();
  
  /** Must be called by each writer thread after it is finished writing.  The calling method must <i>not</i> be 
    * synchronized. This method wakes up any waiting readers and writers.  If there are waiting readers, they read 
    * before the next writer, but any new readers (after this call) wait until the next waiting writer writes.
    * @throws IllegalStateException if the thread is already a reader or writer
    */
  public void endWrite();
  
  /** Class representing a deadlock that would have occurred if the acquire operation had been executed. */
  public static class DeadlockException extends IllegalStateException {
    public DeadlockException() { }
    public DeadlockException(String s) { super(s); }
    public DeadlockException(String s, Throwable t) { super(s,t); }
    public DeadlockException(Throwable t) { super(t); }
  }
}
