import java.util.LinkedList;

/** This class implements synchronization primitives to solve the classic readers/writers problem without deadlock or
  * starvation.
  * Problem: Suppose multiple threads want to read and write a resource. Multiple threads can safely read at the same
  * time, but only one thread can safely write at a time, and no threads can read while a thread is writing. </p> <p>
  * We must be careful to avoid starvation in our solution, so that a steady flow of reader threads cannot block 
  * waiting writer threads indefinitely. This property can be achieved by imposing an ordering on the incoming readers
  * and writers.
  * To use this class, instantiate a ReaderWriterLock in the class holding the shared resource.  Any methods which read
  * from the resource must call startRead before reading and endRead after reading, and must not be synchronized 
  * themselves.  Similarly, any methods which write to the resource must not be synchronized and must call startWrite 
  * before writing and endWrite after writing.
  * This class enforces that any readers and writers that are forced to wait are given access to the shared resource in 
  * the order in which they arrive. Groups of readers are allowed to proceed simultaneously, where each group contains 
  * all waiting readers that arrived before the next waiting writer.
  * 
  * This class is loosely adapted from the "Starvation-Free Readers and Writers Monitor" available from Stephen J. 
  * Hartley (Drexel University) at: http://www.mcs.drexel.edu/~shartley/ConcProgJava/monitors.html
  * We have imposed an ordering on the pending waiting readers and writers using an ordered queue.
  * @author Robert Cartwright, Mathias Ricken and the DrJava team
  */
public class ReaderWriterLock implements IReaderWriterLock {
    // TODO
}
