import junit.framework.TestCase;
import junit.framework.AssertionFailedError;

/**
 * Tests for bounded buffer class.
 * @author Mathias Ricken
 */
public class BoundedBufferTest extends TestCase {
    public void testWR() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(100);
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testRW() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(100);
                    bb.write(new Integer(1));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testWWRR() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(100);
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testRRWW() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(100);
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testFullWrite() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                    bb.write(new Integer(3));
                    bb.write(new Integer(4));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(100);
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                    i = bb.read();
                    assertEquals(new Integer(3),i);
                    i = bb.read();
                    assertEquals(new Integer(4),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testMoreThanFullWrite() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        final Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                    bb.write(new Integer(3));
                    bb.write(new Integer(4));
                    bb.write(new Integer(5));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        final Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(500);
                    if (t1.getState() != Thread.State.WAITING) {
                        fail("t1 should be waiting!");
                    }
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                    i = bb.read();
                    assertEquals(new Integer(3),i);
                    i = bb.read();
                    assertEquals(new Integer(4),i);
                    i = bb.read();
                    assertEquals(new Integer(5),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testMoreThanFullWrite2() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        final Thread t1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                    bb.write(new Integer(3));
                    bb.write(new Integer(4));
                    bb.write(new Integer(5));
                    bb.write(new Integer(5));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        final Thread t2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(500);
                    assertEquals(Thread.State.WAITING, t1.getState());
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    assertEquals(Thread.State.WAITING, t1.getState());
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                    i = bb.read();
                    assertEquals(new Integer(3),i);
                    i = bb.read();
                    assertEquals(new Integer(4),i);
                    i = bb.read();
                    assertEquals(new Integer(5),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
    
    public void testMoreThanFullWriteTwoWriters() {
        final BoundedBuffer<Integer> bb = new BoundedBuffer<Integer>(4);
        final Thread tw1 = new Thread(new Runnable() {
            public void run() {
                try {
                    bb.write(new Integer(1));
                    bb.write(new Integer(2));
                    bb.write(new Integer(3));
                    bb.write(new Integer(4));
                    bb.write(new Integer(5));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        final Thread tw2 = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(300);
                    bb.write(new Integer(5));
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        final Thread tr = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(500);
                    if (tw1.getState() != Thread.State.WAITING) { fail("t1 should be waiting!"); }
                    if (tw2.getState() != Thread.State.WAITING) { fail("t1 should be waiting!"); }
                    Integer i = bb.read();
                    assertEquals(new Integer(1),i);
                    i = bb.read();
                    assertEquals(new Integer(2),i);
                    i = bb.read();
                    assertEquals(new Integer(3),i);
                    i = bb.read();
                    assertEquals(new Integer(4),i);
                    i = bb.read();
                    assertEquals(new Integer(5),i);
                }
                catch(InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        tw1.start();
        tw2.start();
        tr.start();
        try {
            tw1.join();
            tw2.join();
            tr.join();
        }
        catch(InterruptedException e) {
            e.printStackTrace();
        }
    }
}
