import junit.framework.*;

public class CounterTest extends TestCase {
  final long ONE_THREAD = 1000000;
  final int NUM_THREADS = 10;
  
  public void testSingle() {
    Counter c = new Counter();
    c.incrementNTimes(ONE_THREAD);
    
    System.out.println(c.getCount());
    assertEquals(ONE_THREAD, c.getCount());
  }
  
  public void testMulti() {
    final Counter c = new Counter();
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread() { public void run() {
        c.incrementNTimes(ONE_THREAD);
      } };
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(c.getCount()+" diff "+(c.getCount()-(NUM_THREADS*ONE_THREAD)));
//    assertEquals(NUM_THREADS*ONE_THREAD, c.getCount());
  }
  
  public void testCorrectMulti() {
    final Counter c = new Counter();
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread() { public void run() {
        c.incrementNTimesLock(ONE_THREAD);
      } };
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(c.getCount()+" (diff "+(c.getCount()-(NUM_THREADS*ONE_THREAD)));
    assertEquals(NUM_THREADS*ONE_THREAD, c.getCount());
  }
  
  public static void main(String[] args) {
    IncrementTest i = new IncrementTest();
    i.testSingle();
    i.testMulti();
    i.testCorrectMulti();
  }
}
