import junit.framework.*;

public class IncrementTest extends TestCase {
  final long ONE_THREAD = 1000000;
  final int NUM_THREADS = 10;
  long _count = 0;
  final Object _lock = new Object();

  public void testSingle() {
    _count = 0;
    for(long i=0; i<ONE_THREAD; ++i) {
      ++_count;
    }
    
    System.out.println(_count);
    assertEquals(ONE_THREAD, _count);
  }
  
  class IncrementRunnable implements Runnable {
    public void run() {
      for(long i=0; i<ONE_THREAD; ++i) {
        long previous = _count++;
//        assertTrue("previous "+previous+" not less than _count "+_count, previous<_count);
      }
    }
  }
  
  public void testMulti() {
    _count = 0;
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new IncrementRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(_count+" (diff "+(_count-(NUM_THREADS*ONE_THREAD))+
                       ((_count<ONE_THREAD)?", less than ONE_THREAD":"")+")");
    assertEquals(NUM_THREADS*ONE_THREAD, _count);
  }
  
  class IncrementLockRunnable implements Runnable {
    public void run() {
      for(long i=0; i<ONE_THREAD; ++i) {
        synchronized(_lock) {
          long previous = _count++;
//          assertTrue("previous "+previous+" not less than _count "+_count, previous<_count);
        }
      }
    }
  }
  
  public void testCorrectMulti() {
    _count = 0;
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new IncrementLockRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(_count+" (diff "+(_count-(NUM_THREADS*ONE_THREAD))+
                       ((_count<ONE_THREAD)?", less than ONE_THREAD":"")+")");
    assertEquals(NUM_THREADS*ONE_THREAD, _count);
  }
  
  public static void main(String[] args) {
    IncrementTest i = new IncrementTest();
    i.testSingle();
    i.testMulti();
    i.testCorrectMulti();
  }
}
