import javax.swing.*;
import java.lang.reflect.InvocationTargetException;
  
public class InvokeAndWaitDeadlock {
  public static void main(String[] args) {
    try {
      SwingUtilities.invokeAndWait(new Runnable() {
        public void run() {
          // invokeAndWait to put this code in the event thread
          System.out.println("In first Runnable");
          try {
            SwingUtilities.invokeAndWait(new Runnable() {
              public void run() {
                // will never be executed because event thread is still
                // executing the first Runnable
                System.out.println("In second Runnable");
              }
            });
          }
          catch(InterruptedException ie) { /* ignore */ }
          catch(InvocationTargetException ite) { /* ignore */ }
          // will never be executed because event thread will never execute
          // the second Runnable
          System.out.println("Done with first Runnable");
        }
      });
    }
    catch(InterruptedException ie) { /* ignore */ }
    catch(InvocationTargetException ite) { /* ignore */ }
  }
}