import java.util.Random;

public class MultiThreadBankLocks {
  final Random _r = new Random();
  final long INITIAL_FUNDS = 1000000;
  final int NUM_ACCOUNTS = 4;
  final long NUM_TRANSFERS = 1000;
  final int NUM_THREADS = 2;
  long[] _accounts = new long[NUM_ACCOUNTS];
  Object[] _locks = new Object[NUM_ACCOUNTS];
  
  class TransferRunnable implements Runnable {
    public void run() {
      for(int i=0; i<NUM_TRANSFERS; ++i) {
        int from = _r.nextInt(NUM_ACCOUNTS);
        int to   = _r.nextInt(NUM_ACCOUNTS);
        synchronized(_locks[to]) {
          synchronized(_locks[from]) {
            long amount = (long)(_accounts[from]*_r.nextFloat());
            System.out.println(from+" -> "+to+": $"+amount);
            _accounts[from] -= amount;
            _accounts[to]   += amount;        
          }
        }
      }    
    }
  }

  void run() {
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      _accounts[i] = INITIAL_FUNDS;
      _locks[i] = new Object();
    }    
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new TransferRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    check();
    System.out.println("Done.");
  }
  
  void check() {
    long sum = 0;
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      sum += _accounts[i];
    }
    if(sum!=INITIAL_FUNDS*NUM_ACCOUNTS) {
      throw new RuntimeException("Wrong sum: "+sum);
    }
  }
  
  public static void main(String[] args) {
    (new MultiThreadBankLocks()).run();
  }
}