import java.util.Random;
import junit.framework.*;

public class MultiThreadBankTest extends TestCase {
  final Random _r = new Random();
  final long INITIAL_FUNDS = 1000000;
  final int NUM_ACCOUNTS = 4;
  final long NUM_TRANSFERS = 10000;
  final int NUM_THREADS = 2;
  long[] _accounts = new long[NUM_ACCOUNTS];
  
  class TransferRunnable implements Runnable {
    public void run() {
      for(int i=0; i<NUM_TRANSFERS; ++i) {
        int from = _r.nextInt(NUM_ACCOUNTS);
        int to   = _r.nextInt(NUM_ACCOUNTS);
        long amount = (long)(_accounts[from]*_r.nextFloat());
//        System.out.println(from+" -> "+to+": $"+amount);
        _accounts[from] -= amount;
        _accounts[to]   += amount; 
//        check();
      }
    }
  }

  public void testBank() {
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      _accounts[i] = INITIAL_FUNDS;
    }    
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new TransferRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    checkJustPrint();
    System.out.println("Done.");
  }
  
  void check() {
    long sum = 0;
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      sum += _accounts[i];
    }
    if(sum!=INITIAL_FUNDS*NUM_ACCOUNTS) {
      throw new RuntimeException("Wrong sum: "+sum);
    }
  }

  void checkJustPrint() {
    long sum = 0;
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      sum += _accounts[i];
    }
    if(sum!=INITIAL_FUNDS*NUM_ACCOUNTS) {
      System.out.println("Wrong sum: "+sum);
    }
    else {
      System.out.println("Sum: "+sum);
    }
  }
  
  public static void main(String[] args) {
    (new MultiThreadBankTest()).testBank();
  }
}