public class MultiThreadIncrement {
  final long ONE_THREAD = 1000000;
  final int NUM_THREADS = 10;
  long _count = 0;
  
  class IncrementRunnable implements Runnable {
    public void run() {
      for(long i=0; i<ONE_THREAD; ++i) {
        ++_count;
      }
    }
  }
  
  void run() {
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new IncrementRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(_count+" (diff "+(_count-(NUM_THREADS*ONE_THREAD))+
                       ((_count<ONE_THREAD)?", less than ONE_THREAD":"")+")");
  }
  
  public static void main(String[] args) {
    (new MultiThreadIncrement()).run();
  }
}
