import junit.framework.*;

public class MultiThreadIncrementTest extends TestCase {
  final long ONE_THREAD = 1000000;
  final int NUM_THREADS = 10;
  long _count = 0;
  
  class IncrementRunnable implements Runnable {
    public void run() {
      for(long i=0; i<ONE_THREAD; ++i) {
        long previous = _count++;
        assertTrue("previous "+previous+" not less than _count "+_count, previous<_count);
      }
    }
  }
  
  public void testIncrement() {
    Thread[] ts = new Thread[NUM_THREADS];
    for(int i=0; i<NUM_THREADS; ++i) {
      ts[i] = new Thread(new IncrementRunnable());
      ts[i].start();
    }
    for(int i=0; i<NUM_THREADS; ++i) {
      try {
        ts[i].join();
      }
      catch(InterruptedException ie) { /* ignore */ }
    }
    
    System.out.println(_count+" (diff "+(_count-(NUM_THREADS*ONE_THREAD))+
                       ((_count<ONE_THREAD)?", less than ONE_THREAD":"")+")");
//    assertEquals(NUM_THREADS*ONE_THREAD, _count);
  }
  
  public static void main(String[] args) {
    (new MultiThreadIncrementTest()).testIncrement();
  }
}
