public class Philosophers {
  static final int N = 5;
  static Object[] forks = new Object[5];
  
  static class Philosopher implements Runnable {
    int right, left;
    
    public Philosopher(int i) { right = i; left = (right+1)%N; }
    
    public void run() {
      synchronized(forks[right]) {
        System.out.println("Philosopher "+right+" has "+"fork "+right+", tries to get fork "+left);
        synchronized(forks[left]) {
          System.out.println("Philosopher "+right+" eats!");
        }
      }
    }
  }
  
  public static void main(String[] args) {
    Thread[] philosopher = new Thread[N];
    for(int i=0; i<N; ++i) { forks[i] = new Object();
      philosopher[i] = new Thread(new Philosopher(i));
      philosopher[i].start();
    }
    try {
      for(int i=0; i<N; ++i) {
        philosopher[i].join();
      }
    }
    catch(InterruptedException e) { }
    System.out.println("All done eating.");
  }
}