public class PhilosophersMin {
  static final int N = 3;
  static Object[] forks = new Object[N];
  static int[] eaten = new int[N];
  static volatile boolean finish = false;

  static class Philosopher implements Runnable {
    int right, left;
  
    public Philosopher(int i) { right = i; left = (right+1)%N; }
    
    public void run() {
      while(!finish) {
        synchronized(forks[Math.min(left,right)]) {
//          System.out.println("Philosopher "+right+" has "+"fork "+Math.min(left,right)+", tries to get fork "+Math.max(left,right));
          synchronized(forks[Math.max(left,right)]) {
//            System.out.println("Philosopher "+right+" eats!");
            ++eaten[right];
          }
        }
      }
    }
  }
  
  public static void main(String[] args) {
    Thread[] philosopher = new Thread[N];
    for(int i=0; i<N; ++i) { forks[i] = new Object();
      philosopher[i] = new Thread(new Philosopher(i));
    }
    for(int i=0; i<N; ++i) { philosopher[i].start(); }
    try {
      Thread.sleep(30000);
      finish = true;
      for(int i=0; i<N; ++i) {
        philosopher[i].join();
      }
    }
    catch(InterruptedException e) { }
    System.out.println("All done eating.");
    for(int i=0; i<N; ++i) { System.out.println("Philosopher "+i+" ate: "+eaten[i]); }
  }
}