import java.util.Random;

public class SingleThreadBank {
  final Random _r = new Random();
  final long INITIAL_FUNDS = 1000000;
  final int NUM_ACCOUNTS = 4;
  final long NUM_TRANSFERS = 1000;
  long[] _accounts = new long[NUM_ACCOUNTS];
  
  void run() {
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      _accounts[i] = INITIAL_FUNDS;
    }
    
    for(int i=0; i<NUM_TRANSFERS; ++i) {
      int from = _r.nextInt(NUM_ACCOUNTS);
      int to   = _r.nextInt(NUM_ACCOUNTS);
      long amount = (long)(_accounts[from]*_r.nextFloat());
      System.out.println(from+" -> "+to+": $"+amount);
      _accounts[from] -= amount;
      _accounts[to]   += amount;
    }    
    check();
    System.out.println("Done.");
  }
  
  void check() {
    long sum = 0;
    for(int i=0; i<NUM_ACCOUNTS; ++i) {
      sum += _accounts[i];
    }
    if(sum!=INITIAL_FUNDS*NUM_ACCOUNTS) {
      System.out.println(sum);
      System.exit(1);
    }
  }
  
  public static void main(String[] args) {
    (new SingleThreadBank()).run();
  }
}