public class WaitNotifyDemo {
  Object _lock = new Object();
  volatile boolean _flag = false;
  
  void run() {
    Thread t1 = new Thread(new Runnable() {
      public void run() {
        try {
          Thread.sleep(1000);
        }
        catch(InterruptedException ie) { /* ignore */ }
        // must own _lock before we can notify
        synchronized(_lock) {
          _flag = true;
          _lock.notify();
        }
      }
    });
    Thread t2 = new Thread(new Runnable() {
      public void run() {
        // must own _lock before we can notify
        synchronized(_lock) {
          while(!_flag) {
            try {
              _lock.wait();
            }
            catch(InterruptedException ie) { /* ignore */ }
          }
        }
      }
    });
    t1.start();
    t2.start();
    try {
      t1.join();
      t2.join();
    }
    catch(InterruptedException ie) { /* ignore */ }
  }
  
  public static void main(String[] args) {
    (new WaitNotifyDemo()).run();
  }
}
