public class WaitNotifyEarlyDemo {
  Object _lock = new Object();
  
  void run() {
    Thread t1 = new Thread(new Runnable() {
      public void run() {
        // must own _lock before we can notify
        synchronized(_lock) {
          _lock.notify(); // too early
        }
      }
    });
    Thread t2 = new Thread(new Runnable() {
      public void run() {
        try {
          Thread.sleep(1000);
        }
        catch(InterruptedException ie) { /* ignore */ }
        // must own _lock before we can notify
        synchronized(_lock) {
          try {
            _lock.wait(); // will never wake up
          }
          catch(InterruptedException ie) { /* ignore */ }
        }
      }
    });
    t1.start();
    t2.start();
    try {
      t1.join();
      t2.join();
    }
    catch(InterruptedException ie) { /* ignore */ }
  }
  
  public static void main(String[] args) {
    (new WaitNotifyEarlyDemo()).run();
  }
}
