/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.classfile;

import edu.rice.cs.mint.comp.com.sun.tools.classfile.Attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ClassFile;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    private DataInputStream in;
    private ClassFile classFile;
    private Attribute.Factory attributeFactory;

    ClassReader(ClassFile classFile, InputStream inputStream, Attribute.Factory factory) throws IOException {
        classFile.getClass();
        factory.getClass();
        this.classFile = classFile;
        this.in = new DataInputStream(new BufferedInputStream(inputStream));
        this.attributeFactory = factory;
    }

    ClassFile getClassFile() {
        return this.classFile;
    }

    ConstantPool getConstantPool() {
        return this.classFile.constant_pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute readAttribute() throws IOException {
        int n = this.readUnsignedShort();
        int n2 = this.readInt();
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        DataInputStream dataInputStream = this.in;
        this.in = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            Attribute attribute = this.attributeFactory.createAttribute(this, n, byArray);
            return attribute;
        }
        finally {
            this.in = dataInputStream;
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

