/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.classfile;

import edu.rice.cs.mint.comp.com.sun.tools.classfile.Attribute;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Attributes;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ClassFile;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.ConstantPool;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Field;
import edu.rice.cs.mint.comp.com.sun.tools.classfile.Method;
import java.util.Map;

public class ClassTranslator
implements ConstantPool.Visitor<ConstantPool.CPInfo, Map<Object, Object>> {
    public ClassFile translate(ClassFile classFile, Map<Object, Object> map) {
        ClassFile classFile2 = (ClassFile)map.get(classFile);
        if (classFile2 == null) {
            ConstantPool constantPool = this.translate(classFile.constant_pool, map);
            Field[] fieldArray = this.translate(classFile.fields, classFile.constant_pool, map);
            Method[] methodArray = this.translateMethods(classFile.methods, classFile.constant_pool, map);
            Attributes attributes = this.translateAttributes(classFile.attributes, classFile.constant_pool, map);
            classFile2 = constantPool == classFile.constant_pool && fieldArray == classFile.fields && methodArray == classFile.methods && attributes == classFile.attributes ? classFile : new ClassFile(classFile.magic, classFile.minor_version, classFile.major_version, constantPool, classFile.access_flags, classFile.this_class, classFile.super_class, classFile.interfaces, fieldArray, methodArray, attributes);
            map.put(classFile, classFile2);
        }
        return classFile2;
    }

    ConstantPool translate(ConstantPool constantPool, Map<Object, Object> map) {
        ConstantPool constantPool2 = (ConstantPool)map.get(constantPool);
        if (constantPool2 == null) {
            ConstantPool.CPInfo[] cPInfoArray = new ConstantPool.CPInfo[constantPool.size()];
            boolean bl = true;
            for (int i = 0; i < constantPool.size(); ++i) {
                ConstantPool.CPInfo cPInfo;
                try {
                    cPInfo = constantPool.get(i);
                }
                catch (ConstantPool.InvalidIndex invalidIndex) {
                    throw new IllegalStateException(invalidIndex);
                }
                ConstantPool.CPInfo cPInfo2 = this.translate(cPInfo, map);
                bl &= cPInfo == cPInfo2;
                cPInfoArray[i] = cPInfo2;
                if (cPInfo.getTag() != cPInfo2.getTag()) {
                    throw new IllegalStateException();
                }
                switch (cPInfo.getTag()) {
                    case 5: 
                    case 6: {
                        ++i;
                    }
                }
            }
            constantPool2 = bl ? constantPool : new ConstantPool(cPInfoArray);
            map.put(constantPool, constantPool2);
        }
        return constantPool2;
    }

    ConstantPool.CPInfo translate(ConstantPool.CPInfo cPInfo, Map<Object, Object> map) {
        ConstantPool.CPInfo cPInfo2 = (ConstantPool.CPInfo)map.get(cPInfo);
        if (cPInfo2 == null) {
            cPInfo2 = cPInfo.accept(this, map);
            map.put(cPInfo, cPInfo2);
        }
        return cPInfo2;
    }

    Field[] translate(Field[] fieldArray, ConstantPool constantPool, Map<Object, Object> map) {
        Field[] fieldArray2 = (Field[])map.get(fieldArray);
        if (fieldArray2 == null) {
            fieldArray2 = new Field[fieldArray.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                fieldArray2[i] = this.translate(fieldArray[i], constantPool, map);
            }
            if (ClassTranslator.equal(fieldArray, fieldArray2)) {
                fieldArray2 = fieldArray;
            }
            map.put(fieldArray, fieldArray2);
        }
        return fieldArray2;
    }

    Field translate(Field field, ConstantPool constantPool, Map<Object, Object> map) {
        Field field2 = (Field)map.get(field);
        if (field2 == null) {
            Attributes attributes = this.translateAttributes(field.attributes, constantPool, map);
            field2 = attributes == field.attributes ? field : new Field(field.access_flags, field.name_index, field.descriptor, attributes);
            map.put(field, field2);
        }
        return field2;
    }

    Method[] translateMethods(Method[] methodArray, ConstantPool constantPool, Map<Object, Object> map) {
        Method[] methodArray2 = (Method[])map.get(methodArray);
        if (methodArray2 == null) {
            methodArray2 = new Method[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                methodArray2[i] = this.translate(methodArray[i], constantPool, map);
            }
            if (ClassTranslator.equal(methodArray, methodArray2)) {
                methodArray2 = methodArray;
            }
            map.put(methodArray, methodArray2);
        }
        return methodArray2;
    }

    Method translate(Method method, ConstantPool constantPool, Map<Object, Object> map) {
        Method method2 = (Method)map.get(method);
        if (method2 == null) {
            Attributes attributes = this.translateAttributes(method.attributes, constantPool, map);
            method2 = attributes == method.attributes ? method : new Method(method.access_flags, method.name_index, method.descriptor, attributes);
            map.put(method, method2);
        }
        return method2;
    }

    Attributes translateAttributes(Attributes attributes, ConstantPool constantPool, Map<Object, Object> map) {
        Attributes attributes2 = (Attributes)map.get(attributes);
        if (attributes2 == null) {
            Attribute[] attributeArray = new Attribute[attributes.size()];
            ConstantPool constantPool2 = this.translate(constantPool, map);
            boolean bl = true;
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = attributes.get(i);
                Attribute attribute2 = this.translate(attribute, map);
                if (attribute2 != attribute) {
                    bl = false;
                }
                attributeArray[i] = attribute2;
            }
            attributes2 = constantPool2 == constantPool && bl ? attributes : new Attributes(constantPool2, attributeArray);
            map.put(attributes, attributes2);
        }
        return attributes2;
    }

    Attribute translate(Attribute attribute, Map<Object, Object> map) {
        Attribute attribute2 = (Attribute)map.get(attribute);
        if (attribute2 == null) {
            attribute2 = attribute;
            map.put(attribute, attribute2);
        }
        return attribute2;
    }

    private static <T> boolean equal(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray2 == null) {
            return TArray == TArray2;
        }
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConstantPool.CPInfo visitClass(ConstantPool.CONSTANT_Class_info cONSTANT_Class_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Class_info cONSTANT_Class_info2 = (ConstantPool.CONSTANT_Class_info)map.get(cONSTANT_Class_info);
        if (cONSTANT_Class_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_Class_info.cp, map);
            cONSTANT_Class_info2 = constantPool == cONSTANT_Class_info.cp ? cONSTANT_Class_info : new ConstantPool.CONSTANT_Class_info(constantPool, cONSTANT_Class_info.name_index);
            map.put(cONSTANT_Class_info, cONSTANT_Class_info2);
        }
        return cONSTANT_Class_info;
    }

    @Override
    public ConstantPool.CPInfo visitDouble(ConstantPool.CONSTANT_Double_info cONSTANT_Double_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Double_info cONSTANT_Double_info2 = (ConstantPool.CONSTANT_Double_info)map.get(cONSTANT_Double_info);
        if (cONSTANT_Double_info2 == null) {
            cONSTANT_Double_info2 = cONSTANT_Double_info;
            map.put(cONSTANT_Double_info, cONSTANT_Double_info2);
        }
        return cONSTANT_Double_info;
    }

    @Override
    public ConstantPool.CPInfo visitFieldref(ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Fieldref_info cONSTANT_Fieldref_info2 = (ConstantPool.CONSTANT_Fieldref_info)map.get(cONSTANT_Fieldref_info);
        if (cONSTANT_Fieldref_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_Fieldref_info.cp, map);
            cONSTANT_Fieldref_info2 = constantPool == cONSTANT_Fieldref_info.cp ? cONSTANT_Fieldref_info : new ConstantPool.CONSTANT_Fieldref_info(constantPool, cONSTANT_Fieldref_info.class_index, cONSTANT_Fieldref_info.name_and_type_index);
            map.put(cONSTANT_Fieldref_info, cONSTANT_Fieldref_info2);
        }
        return cONSTANT_Fieldref_info;
    }

    @Override
    public ConstantPool.CPInfo visitFloat(ConstantPool.CONSTANT_Float_info cONSTANT_Float_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Float_info cONSTANT_Float_info2 = (ConstantPool.CONSTANT_Float_info)map.get(cONSTANT_Float_info);
        if (cONSTANT_Float_info2 == null) {
            cONSTANT_Float_info2 = cONSTANT_Float_info;
            map.put(cONSTANT_Float_info, cONSTANT_Float_info2);
        }
        return cONSTANT_Float_info;
    }

    @Override
    public ConstantPool.CPInfo visitInteger(ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info2 = (ConstantPool.CONSTANT_Integer_info)map.get(cONSTANT_Integer_info);
        if (cONSTANT_Integer_info2 == null) {
            cONSTANT_Integer_info2 = cONSTANT_Integer_info;
            map.put(cONSTANT_Integer_info, cONSTANT_Integer_info2);
        }
        return cONSTANT_Integer_info;
    }

    @Override
    public ConstantPool.CPInfo visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_InterfaceMethodref_info cONSTANT_InterfaceMethodref_info2 = (ConstantPool.CONSTANT_InterfaceMethodref_info)map.get(cONSTANT_InterfaceMethodref_info);
        if (cONSTANT_InterfaceMethodref_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_InterfaceMethodref_info.cp, map);
            cONSTANT_InterfaceMethodref_info2 = constantPool == cONSTANT_InterfaceMethodref_info.cp ? cONSTANT_InterfaceMethodref_info : new ConstantPool.CONSTANT_InterfaceMethodref_info(constantPool, cONSTANT_InterfaceMethodref_info.class_index, cONSTANT_InterfaceMethodref_info.name_and_type_index);
            map.put(cONSTANT_InterfaceMethodref_info, cONSTANT_InterfaceMethodref_info2);
        }
        return cONSTANT_InterfaceMethodref_info;
    }

    @Override
    public ConstantPool.CPInfo visitLong(ConstantPool.CONSTANT_Long_info cONSTANT_Long_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Long_info cONSTANT_Long_info2 = (ConstantPool.CONSTANT_Long_info)map.get(cONSTANT_Long_info);
        if (cONSTANT_Long_info2 == null) {
            cONSTANT_Long_info2 = cONSTANT_Long_info;
            map.put(cONSTANT_Long_info, cONSTANT_Long_info2);
        }
        return cONSTANT_Long_info;
    }

    @Override
    public ConstantPool.CPInfo visitNameAndType(ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_NameAndType_info cONSTANT_NameAndType_info2 = (ConstantPool.CONSTANT_NameAndType_info)map.get(cONSTANT_NameAndType_info);
        if (cONSTANT_NameAndType_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_NameAndType_info.cp, map);
            cONSTANT_NameAndType_info2 = constantPool == cONSTANT_NameAndType_info.cp ? cONSTANT_NameAndType_info : new ConstantPool.CONSTANT_NameAndType_info(constantPool, cONSTANT_NameAndType_info.name_index, cONSTANT_NameAndType_info.type_index);
            map.put(cONSTANT_NameAndType_info, cONSTANT_NameAndType_info2);
        }
        return cONSTANT_NameAndType_info;
    }

    @Override
    public ConstantPool.CPInfo visitMethodref(ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Methodref_info cONSTANT_Methodref_info2 = (ConstantPool.CONSTANT_Methodref_info)map.get(cONSTANT_Methodref_info);
        if (cONSTANT_Methodref_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_Methodref_info.cp, map);
            cONSTANT_Methodref_info2 = constantPool == cONSTANT_Methodref_info.cp ? cONSTANT_Methodref_info : new ConstantPool.CONSTANT_Methodref_info(constantPool, cONSTANT_Methodref_info.class_index, cONSTANT_Methodref_info.name_and_type_index);
            map.put(cONSTANT_Methodref_info, cONSTANT_Methodref_info2);
        }
        return cONSTANT_Methodref_info;
    }

    @Override
    public ConstantPool.CPInfo visitString(ConstantPool.CONSTANT_String_info cONSTANT_String_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_String_info cONSTANT_String_info2 = (ConstantPool.CONSTANT_String_info)map.get(cONSTANT_String_info);
        if (cONSTANT_String_info2 == null) {
            ConstantPool constantPool = this.translate(cONSTANT_String_info.cp, map);
            cONSTANT_String_info2 = constantPool == cONSTANT_String_info.cp ? cONSTANT_String_info : new ConstantPool.CONSTANT_String_info(constantPool, cONSTANT_String_info.string_index);
            map.put(cONSTANT_String_info, cONSTANT_String_info2);
        }
        return cONSTANT_String_info;
    }

    @Override
    public ConstantPool.CPInfo visitUtf8(ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info, Map<Object, Object> map) {
        ConstantPool.CONSTANT_Utf8_info cONSTANT_Utf8_info2 = (ConstantPool.CONSTANT_Utf8_info)map.get(cONSTANT_Utf8_info);
        if (cONSTANT_Utf8_info2 == null) {
            cONSTANT_Utf8_info2 = cONSTANT_Utf8_info;
            map.put(cONSTANT_Utf8_info, cONSTANT_Utf8_info2);
        }
        return cONSTANT_Utf8_info;
    }
}

