/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.file;

import edu.rice.cs.mint.comp.com.sun.tools.javac.file.BaseFileObject;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.JavacFileManager;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;

class RegularFileObject
extends BaseFileObject {
    private boolean hasParents = false;
    private String name;
    final File f;

    public RegularFileObject(JavacFileManager javacFileManager, File file) {
        this(javacFileManager, file.getName(), file);
    }

    public RegularFileObject(JavacFileManager javacFileManager, String string, File file) {
        super(javacFileManager);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.name = string;
        this.f = file;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    @Override
    protected CharsetDecoder getDecoder(boolean bl) {
        return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.ensureParentDirectoriesExist();
        return new FileOutputStream(this.f);
    }

    @Override
    public Writer openWriter() throws IOException {
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), this.fileManager.getEncodingName());
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> iterable) {
        String string = this.f.getPath();
        for (File file : iterable) {
            String string2 = file.getPath();
            if (string2.length() == 0) {
                string2 = System.getProperty("user.dir");
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!string.regionMatches(true, 0, string2, 0, string2.length()) || !new File(string.substring(0, string2.length())).equals(new File(string2))) continue;
            String string3 = string.substring(string2.length());
            return RegularFileObject.removeExtension(string3).replace(File.separatorChar, '.');
        }
        return null;
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            File file = this.f.getParentFile();
            if (!(file == null || file.exists() || file.mkdirs() || file.exists() && file.isDirectory())) {
                throw new IOException("could not create parent directories");
            }
            this.hasParents = true;
        }
    }

    @Override
    @Deprecated
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        string.getClass();
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String string2 = string + kind.extension;
        if (this.name.equals(string2)) {
            return true;
        }
        if (this.name.equalsIgnoreCase(string2)) {
            try {
                return this.f.getCanonicalFile().getName().equals(string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public String getPath() {
        return this.f.getPath();
    }

    @Override
    public long getLastModified() {
        return this.f.lastModified();
    }

    @Override
    public boolean delete() {
        return this.f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean bl) throws IOException {
        CharBuffer charBuffer = this.fileManager.getCachedContent(this);
        if (charBuffer == null) {
            FileInputStream fileInputStream = new FileInputStream(this.f);
            try {
                ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(fileInputStream);
                JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                try {
                    charBuffer = this.fileManager.decode(byteBuffer, bl);
                }
                finally {
                    this.fileManager.log.useSource(javaFileObject);
                }
                this.fileManager.recycleByteBuffer(byteBuffer);
                if (!bl) {
                    this.fileManager.cache(this, charBuffer);
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return charBuffer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegularFileObject)) {
            return false;
        }
        RegularFileObject regularFileObject = (RegularFileObject)object;
        try {
            return this.f.equals(regularFileObject.f) || this.f.getCanonicalFile().equals(regularFileObject.f.getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    @Override
    public URI toUri() {
        try {
            String string = this.f.getAbsolutePath().replace(File.separatorChar, '/');
            return new URI("file://" + string).normalize();
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.f.toURI();
        }
    }
}

