/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.util;

import edu.rice.cs.mint.comp.com.sun.tools.javac.api.DiagnosticFormatter;
import edu.rice.cs.mint.comp.com.sun.tools.javac.api.Formattable;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.JavacFileManager;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.DiagnosticSource;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JCDiagnostic;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JavacMessages;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ListBuffer;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractDiagnosticFormatter
implements DiagnosticFormatter<JCDiagnostic> {
    protected JavacMessages messages;
    protected boolean showSource;

    protected AbstractDiagnosticFormatter(JavacMessages javacMessages, Options options, boolean bl) {
        this.messages = javacMessages;
        this.showSource = options.get("showSource") == null ? bl : options.get("showSource").equals("true");
    }

    protected AbstractDiagnosticFormatter(JavacMessages javacMessages, boolean bl) {
        this.messages = javacMessages;
        this.showSource = bl;
    }

    @Override
    public String formatMessage(JCDiagnostic jCDiagnostic, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        Collection<String> collection = this.formatArguments(jCDiagnostic, locale);
        stringBuilder.append(this.localize(locale, jCDiagnostic.getCode(), collection.toArray()));
        if (jCDiagnostic.isMultiline()) {
            stringBuilder.append(this.formatSubdiagnostics(jCDiagnostic, locale));
        }
        return stringBuilder.toString();
    }

    @Override
    public String formatKind(JCDiagnostic jCDiagnostic, Locale locale) {
        switch (jCDiagnostic.getType()) {
            case FRAGMENT: {
                return "";
            }
            case NOTE: {
                return this.localize(locale, "compiler.note.note", new Object[0]);
            }
            case WARNING: {
                return this.localize(locale, "compiler.warn.warning", new Object[0]);
            }
            case ERROR: {
                return this.localize(locale, "compiler.err.error", new Object[0]);
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic type: " + (Object)((Object)jCDiagnostic.getType())));
    }

    @Override
    public String formatPosition(JCDiagnostic jCDiagnostic, DiagnosticFormatter.PositionKind positionKind, Locale locale) {
        assert (jCDiagnostic.getPosition() != -1L);
        return String.valueOf(this.getPosition(jCDiagnostic, positionKind));
    }

    public long getPosition(JCDiagnostic jCDiagnostic, DiagnosticFormatter.PositionKind positionKind) {
        switch (positionKind) {
            case START: {
                return jCDiagnostic.getIntStartPosition();
            }
            case END: {
                return jCDiagnostic.getIntEndPosition();
            }
            case LINE: {
                return jCDiagnostic.getLineNumber();
            }
            case COLUMN: {
                return jCDiagnostic.getColumnNumber();
            }
            case OFFSET: {
                return jCDiagnostic.getIntPosition();
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic position: " + (Object)((Object)positionKind)));
    }

    @Override
    public String formatSource(JCDiagnostic jCDiagnostic, boolean bl, Locale locale) {
        assert (jCDiagnostic.getSource() != null);
        return bl ? jCDiagnostic.getSourceName() : jCDiagnostic.getSource().getName();
    }

    protected Collection<String> formatArguments(JCDiagnostic jCDiagnostic, Locale locale) {
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        for (Object object : jCDiagnostic.getArgs()) {
            listBuffer.append(this.formatArgument(jCDiagnostic, object, locale));
        }
        return listBuffer.toList();
    }

    protected String formatArgument(JCDiagnostic jCDiagnostic, Object object, Locale locale) {
        if (object instanceof JCDiagnostic) {
            return this.format((JCDiagnostic)object, locale);
        }
        if (object instanceof Iterable) {
            return this.formatIterable(jCDiagnostic, (Iterable)object, locale);
        }
        if (object instanceof JavaFileObject) {
            return JavacFileManager.getJavacBaseFileName((JavaFileObject)object);
        }
        if (object instanceof Formattable) {
            return ((Formattable)object).toString(locale, this.messages);
        }
        return String.valueOf(object);
    }

    protected String formatIterable(JCDiagnostic jCDiagnostic, Iterable<?> iterable, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Object obj : iterable) {
            stringBuilder.append(string);
            stringBuilder.append(this.formatArgument(jCDiagnostic, obj, locale));
            string = ",";
        }
        return stringBuilder.toString();
    }

    protected String formatSubdiagnostics(JCDiagnostic jCDiagnostic, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        for (JCDiagnostic jCDiagnostic2 : jCDiagnostic.getSubdiagnostics()) {
            stringBuilder.append('\n');
            String string = this.format(jCDiagnostic2, locale);
            stringBuilder.append(this.indent(string, 2));
        }
        return stringBuilder.toString();
    }

    protected String formatSourceLine(JCDiagnostic jCDiagnostic) {
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        int n = jCDiagnostic.getIntPosition();
        if (jCDiagnostic.getIntPosition() != -1) {
            String string;
            String string2 = string = diagnosticSource == null ? null : diagnosticSource.getLine(n);
            if (string == null) {
                return "";
            }
            stringBuilder.append(string + "\n");
            int n2 = diagnosticSource.getColumnNumber(n, false);
            for (int i = 0; i < n2 - 1; ++i) {
                stringBuilder.append(string.charAt(i) == '\t' ? "\t" : " ");
            }
            stringBuilder.append("^");
        }
        return stringBuilder.toString();
    }

    protected String localize(Locale locale, String string, Object ... objectArray) {
        return this.messages.getLocalizedString(locale, string, objectArray);
    }

    @Override
    public boolean displaySource(JCDiagnostic jCDiagnostic) {
        return this.showSource && jCDiagnostic.getType() != JCDiagnostic.DiagnosticType.FRAGMENT;
    }

    protected String indentString(int n) {
        String string = "                        ";
        if (n <= string.length()) {
            return string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected String indent(String string, int n) {
        String string2 = this.indentString(n);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        for (String string4 : string.split("\n")) {
            stringBuilder.append(string3);
            stringBuilder.append(string2 + string4);
            string3 = "\n";
        }
        return stringBuilder.toString();
    }
}

