/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.com.sun.tools.javac.util;

import java.util.BitSet;

public class Position {
    public static final int NOPOS = -1;
    public static final int FIRSTPOS = 0;
    public static final int FIRSTLINE = 1;
    public static final int FIRSTCOLUMN = 1;
    public static final int LINESHIFT = 10;
    public static final int MAXCOLUMN = 1023;
    public static final int MAXLINE = 0x3FFFFF;
    public static final int MAXPOS = Integer.MAX_VALUE;

    private Position() {
    }

    public static LineMap makeLineMap(char[] cArray, int n, boolean bl) {
        LineMapImpl lineMapImpl = bl ? new LineTabMapImpl(n) : new LineMapImpl();
        lineMapImpl.build(cArray, n);
        return lineMapImpl;
    }

    public static int encodePosition(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("line must be greater than 0");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("column must be greater than 0");
        }
        if (n > 0x3FFFFF || n2 > 1023) {
            return -1;
        }
        return (n << 10) + n2;
    }

    public static class LineTabMapImpl
    extends LineMapImpl {
        private BitSet tabMap;

        public LineTabMapImpl(int n) {
            this.tabMap = new BitSet(n);
        }

        protected void setTabPosition(int n) {
            this.tabMap.set(n);
        }

        public int getColumnNumber(int n) {
            int n2 = this.startPosition[this.getLineNumber(n) - 1];
            int n3 = 0;
            for (int i = n2; i < n; ++i) {
                if (this.tabMap.get(i)) {
                    n3 = n3 / 8 * 8 + 8;
                    continue;
                }
                ++n3;
            }
            return n3 + 1;
        }

        public int getPosition(int n, int n2) {
            int n3 = this.startPosition[n - 1];
            --n2;
            int n4 = 0;
            while (n4 < n2) {
                if (this.tabMap.get(++n3)) {
                    n4 = n4 / 8 * 8 + 8;
                    continue;
                }
                ++n4;
            }
            return n3;
        }
    }

    static class LineMapImpl
    implements LineMap {
        protected int[] startPosition;
        private int lastPosition = 0;
        private int lastLine = 1;

        protected LineMapImpl() {
        }

        protected void build(char[] cArray, int n) {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[n];
            block0: while (n3 < n) {
                nArray[n2++] = n3;
                do {
                    char c;
                    if ((c = cArray[n3]) == '\r' || c == '\n') {
                        if (c == '\r' && n3 + 1 < n && cArray[n3 + 1] == '\n') {
                            n3 += 2;
                            continue block0;
                        }
                        ++n3;
                        continue block0;
                    }
                    if (c != '\t') continue;
                    this.setTabPosition(n3);
                } while (++n3 < n);
            }
            this.startPosition = new int[n2];
            System.arraycopy(nArray, 0, this.startPosition, 0, n2);
        }

        public int getStartPosition(int n) {
            return this.startPosition[n - 1];
        }

        public long getStartPosition(long l) {
            return this.getStartPosition(LineMapImpl.longToInt(l));
        }

        public int getPosition(int n, int n2) {
            return this.startPosition[n - 1] + n2 - 1;
        }

        public long getPosition(long l, long l2) {
            return this.getPosition(LineMapImpl.longToInt(l), LineMapImpl.longToInt(l2));
        }

        public int getLineNumber(int n) {
            if (n == this.lastPosition) {
                return this.lastLine;
            }
            this.lastPosition = n;
            int n2 = 0;
            int n3 = this.startPosition.length - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                int n5 = this.startPosition[n4];
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n5 > n) {
                    n3 = n4 - 1;
                    continue;
                }
                this.lastLine = n4 + 1;
                return this.lastLine;
            }
            this.lastLine = n2;
            return this.lastLine;
        }

        public long getLineNumber(long l) {
            return this.getLineNumber(LineMapImpl.longToInt(l));
        }

        public int getColumnNumber(int n) {
            return n - this.startPosition[this.getLineNumber(n) - 1] + 1;
        }

        public long getColumnNumber(long l) {
            return this.getColumnNumber(LineMapImpl.longToInt(l));
        }

        private static int longToInt(long l) {
            int n = (int)l;
            if ((long)n != l) {
                throw new IndexOutOfBoundsException();
            }
            return n;
        }

        protected void setTabPosition(int n) {
        }
    }

    public static interface LineMap
    extends edu.rice.cs.mint.comp.com.sun.source.tree.LineMap {
        public int getStartPosition(int var1);

        public int getPosition(int var1, int var2);

        public int getLineNumber(int var1);

        public int getColumnNumber(int var1);
    }
}

