/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.mint.comp.javax.annotation.processing;

import edu.rice.cs.mint.comp.javax.annotation.processing.Completion;
import edu.rice.cs.mint.comp.javax.annotation.processing.ProcessingEnvironment;
import edu.rice.cs.mint.comp.javax.annotation.processing.Processor;
import edu.rice.cs.mint.comp.javax.annotation.processing.RoundEnvironment;
import edu.rice.cs.mint.comp.javax.annotation.processing.SupportedAnnotationTypes;
import edu.rice.cs.mint.comp.javax.annotation.processing.SupportedOptions;
import edu.rice.cs.mint.comp.javax.annotation.processing.SupportedSourceVersion;
import edu.rice.cs.mint.comp.javax.lang.model.SourceVersion;
import edu.rice.cs.mint.comp.javax.lang.model.element.AnnotationMirror;
import edu.rice.cs.mint.comp.javax.lang.model.element.Element;
import edu.rice.cs.mint.comp.javax.lang.model.element.ExecutableElement;
import edu.rice.cs.mint.comp.javax.lang.model.element.TypeElement;
import edu.rice.cs.mint.comp.javax.tools.Diagnostic;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public Set<String> getSupportedOptions() {
        SupportedOptions supportedOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (supportedOptions == null) {
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(supportedOptions.value());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes supportedAnnotationTypes = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (supportedAnnotationTypes == null) {
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
            }
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(supportedAnnotationTypes.value());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion supportedSourceVersion = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sourceVersion = null;
        if (supportedSourceVersion == null) {
            sourceVersion = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedSourceVersion annotation found on " + this.getClass().getName() + ", returning " + (Object)((Object)sourceVersion) + ".");
            }
        } else {
            sourceVersion = supportedSourceVersion.value();
        }
        return sourceVersion;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        if (processingEnvironment == null) {
            throw new NullPointerException("Tool provided null ProcessingEnvironment");
        }
        this.processingEnv = processingEnvironment;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        return Collections.emptyList();
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private static Set<String> arrayToSet(String[] stringArray) {
        assert (stringArray != null);
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

