/*
 * Copyright 2005-2006 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package edu.rice.cs.mint.comp.javax.lang.model.type;


import java.util.List;

import edu.rice.cs.mint.comp.javax.lang.model.element.Element;


/**
 * Represents a declared type, either a class type or an interface type.
 * This includes parameterized types such as {@code java.util.Set<String>}
 * as well as raw types.
 *
 * <p> While a {@code TypeElement} represents a class or interface
 * <i>element</i>, a {@code DeclaredType} represents a class
 * or interface <i>type</i>, the latter being a use
 * (or <i>invocation</i>) of the former.
 * See {@link edu.rice.cs.mint.comp.javax.lang.model.element.TypeElement} for more on this distinction.
 *
 * <p> The supertypes (both class and interface types) of a declared
 * type may be found using the {@link
 * edu.rice.cs.mint.comp.javax.lang.model.util.Types#directSupertypes(edu.rice.cs.mint.comp.javax.lang.model.type.TypeMirror)} method.  This returns the
 * supertypes with any type arguments substituted in.
 *
 * <p> This interface is also used to represent intersection types.
 * An intersection type is implicit in a program rather than being
 * explictly declared.  For example, the bound of the type parameter
 * {@code <T extends Number & Runnable>}
 * is an intersection type.  It is represented by a {@code DeclaredType}
 * with {@code Number} as its superclass and {@code Runnable} as its
 * lone superinterface.
 *
 * @author Joseph D. Darcy
 * @author Scott Seligman
 * @author Peter von der Ah&eacute;
 * @see edu.rice.cs.mint.comp.javax.lang.model.element.TypeElement
 * @since 1.6
 */
public interface DeclaredType extends ReferenceType {

    /**
     * Returns the element corresponding to this type.
     *
     * @return the element corresponding to this type
     */
    Element asElement();

    /**
     * Returns the type of the innermost enclosing instance or a
     * {@code NoType} of kind {@code NONE} if there is no enclosing
     * instance.  Only types corresponding to inner classes have an
     * enclosing instance.
     *
     * @return a type mirror for the enclosing type
     * @jls3 8.1.3 Inner Classes and Enclosing Instances
     * @jls3 15.9.2 Determining Enclosing Instances
     */
    edu.rice.cs.mint.comp.javax.lang.model.type.TypeMirror getEnclosingType();

    /**
     * Returns the actual type arguments of this type.
     * For a type nested within a parameterized type
     * (such as {@code Outer<String>.Inner<Number>}), only the type
     * arguments of the innermost type are included.
     *
     * @return the actual type arguments of this type, or an empty list
     *           if none
     */
    List<? extends edu.rice.cs.mint.comp.javax.lang.model.type.TypeMirror> getTypeArguments();
}
