import edu.rice.cs.mint.runtime.Code;

public class BracketSample {
    public static void voidFn() { }
    public static void printInt (int x) {
        System.out.println ("printInt called with " + x);
    }
    public static void main(String[] args) {
        // works: prints 123
        System.out.println((<|123|>).run());
        
        // works: prints nothing
        <|123|>.run();
        
        // works: prints 123
        edu.rice.cs.mint.runtime.Code<Integer> c = <|123|>;
        System.out.println(c.run());
        
        // works: prints out foo!\nbar!
        edu.rice.cs.mint.runtime.Code<Void> c2 = <| {
            System.out.println("foo!");
            System.out.println("bar!");
        } |>;
        c2.run();
        
        // works: return type has array type
        String[] sarr = <| new String[] {"foo","bar"} |>.run();
        System.out.println(java.util.Arrays.toString(sarr));
        
        // works: must quantify with BracketSample class though
        edu.rice.cs.mint.runtime.Code<Void> c3 = <| { BracketSample.voidFn(); } |>;
        c3.run();
        
        Code<Void> c4 = <| {
            int x = 0;
            for (int i = 0; i <= 10; ++i) {
                x += i;
            }
            BracketSample.printInt (x);
        } |>;
        c4.run ();
        
        Code<Void> c5 = <| {
            int x = 0;
            x = 5;
            BracketSample.printInt (x);
        } |>;
        c5.run ();
    }
}
