import edu.rice.cs.mint.runtime.Code;
import edu.rice.cs.mint.runtime.SafeCode;

public class Fib{
    public static void main(String[] args){
        System.out.println(Fib(2, 3, 17));
        Code<? extends FibFun> CodeFib6 = <| new FibFun() {
            public int Fib(final int x,final int y){
                return `(Fib2(<|x|>,<|y|>, 17));
            }
        } |>;
        FibFun sfib6 = CodeFib6.run();
        System.out.println(sfib6.Fib(2,3));
    }
    
    public static int Fib(int x,int y, int n){
        if (n == 0)
            return x;
        else
            return Fib(y,x+y,n-1);
    }
    
    public static separable SafeCode<Integer> Fib2(SafeCode<Integer> x,
                                                   SafeCode<Integer> y,
                                                   int n){
        if (n == 0)
            return x;
        else
        {
            SafeCode<Integer> z = <|`x+`y|>; 
            return <|  `(Fib2(y,z, n-1)) |>;
        }
    }
    
    public static abstract class FibFun{
        public abstract int Fib(int x,int y);
    }
}
