package hj.array;


public class RegionRectangular {
    
    public final int low_I, low_J, low_K, low_L, low_M;
    public final int lg_I, lg_J, lg_K, lg_L, lg_M;
    public final int rank;
    public final int base;
    
    public separable RegionRectangular(final int [] r, int base) {
        rank = (r.length / 2);
        low_I = (rank >= 1) ? r[0] : 0; // low bound for dim 1
        lg_I  = (rank >= 1) ? r[1] - low_I + 1: 0; // high bound for dim 1
        low_J = (rank >= 2) ? r[2] : 0;
        lg_J  = (rank >= 2) ? r[3] - low_J + 1: 0;
        low_K = (rank >= 3) ? r[4] : 0;
        lg_K  = (rank >= 3) ? r[5] + low_K + 1: 0;
        low_L = (rank >= 4) ? r[6] : 0;
        lg_L  = (rank >= 4) ? r[7] + low_L + 1: 0;
        low_M = (rank >= 5) ? r[8] : 0;
        lg_M  = (rank >= 5) ? r[9] + low_M + 1: 0;
        
        if (rank > 5) {
            throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
        }
        
        
        this.base = base;
    }
    
    
    public final separable int ordinal(int i) {
        return i-low_I;
    }
    
    public final separable int ordinal(int i, int j) {
        return (j-low_J) + (i-low_I) * lg_J;
    }
    
    public final separable int ordinal(int i, int j, int k) {
        return (k-low_K) + (j-low_J)*(lg_K)+ (i-low_I)*lg_K*lg_J;
    }
    
    public final separable int ordinal(int i, int j, int k, int l) {
        return (l-low_L) + (k-low_K)*(lg_L) + (j-low_J)*(lg_L*lg_K)+ (i-low_I)*(lg_L*lg_K*lg_J);
    }
    
    public final separable int ordinal(int i, int j, int k, int l, int m) {
        return (m-low_M) + (l-low_L)*(lg_M) + (k-low_K)*(lg_M*lg_L) + (j-low_J)*(lg_M*lg_L*lg_K)+ (i-low_I)*(lg_M*lg_L*lg_K*lg_J);
    }
    
    
    public separable int getDimensionSize(int dimension) {
        if (dimension == 1) {
            return lg_I;
        }
        if (dimension == 2) {
            return lg_J;
        }
        if (dimension == 3) {
            return lg_K;
        }
        if (dimension == 4) {
            return lg_L;
        }
        if (dimension == 5) {
            return lg_M;
        }
        
        throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
        
    }
    
    public separable String toString() {
        int dimension = 1;
        String res = "";
        while (dimension < 6) {
            res += "[" + getDimensionSize(dimension++) + "]";
        }
        return res;
    }
}