package hj.array.view;

import habanero.bhp.complex64;
import hj.array.SRegionRectangular;
import hj.lang.SArrayView;
import edu.rice.cs.mint.runtime.*;

public final class SComplexDoubleArrayView extends SComplexArrayView {
    
    public final SafeCode<double[]> baseArray;
    
    public SComplexDoubleArrayView(SafeCode<double[]> baseArray, int offset, SRegionRectangular r) {
        super(offset, r);
        this.baseArray = baseArray;
    }
    
    
    public final separable SafeCode<Double> get(final int i) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>))] |>;
    }
    
    
    public final separable SafeCode<Double> get(final int i, final int j) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>))] |>;
    }
    
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>))] |>;
    }
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k, final int l) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>))] |>;
    }
    
    public final separable SafeCode<Double> get(final int i, final int j, final int k, final int l, final int m) {
        return <| `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|m|>))] |>;
    }
    
    public final separable SafeCode<Void> set(final double r, final int i) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>))] = r; } |>;
    }
    
    
    public final separable SafeCode<Void> set(final double r, final int i, final int j) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>))] = r; } |>;
    }
    
    
    public final separable SafeCode<Void> set(final double r, final int i, final int j, final int k) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>))] = r; } |>;
    }
    
    public final separable SafeCode<Void> set(final double r, final int i, final int j, final int k, final int l) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>))] = r; } |>;
    }
    
    public final separable SafeCode<Void> set(final double r, final int i, final int j, final int k, final int l, final int m) {
        return <| { `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|m|>))] = r; } |>;
    }

    public final separable SafeCode<complex64> getc64(final int i) {
        return <| new complex64(`(baseArray)[`(offset) + `(region.ordinal(<|2*i|>))],
                              `(baseArray)[`(offset) + `(region.ordinal(<|2*i+1|>))]) |>;
    }
    
    public final separable SafeCode<complex64> getc64(final int i, final int j) {
        return <| new complex64(`(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|2*j|>))],
                              `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|2*j+1|>))]) |>;
    }
    
    public final separable SafeCode<complex64> getc64(final int i, final int j, final int k) {
        return <| new complex64(`(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|2*k|>))],
                              `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|2*k+1|>))]) |>;
    }
    
    public final separable SafeCode<complex64> getc64(final int i, final int j, final int k, final int l) {
        return <| new complex64(`(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|2*l|>))],
                              `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|2*l+1|>))]) |>;
    }
    
    public final separable SafeCode<complex64> getc64(final int i, final int j, final int k, final int l, final int m) {
        return <| new complex64(`(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|2*m|>))],
                              `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|2*m+1|>))]) |>;
    }
    
    public final separable SafeCode<Void> setc64(complex64 r, final int i) {
        final double real = r.real;
        final double imag = r.imag;
        return <| {
            `(baseArray)[`(offset) + `(region.ordinal(<|2*i|>))] = real;
            `(baseArray)[`(offset) + `(region.ordinal(<|2*i+1|>))] = imag;
        } |>;
    }
    
    
    public final separable SafeCode<Void> setc64(complex64 r, final int i, final int j) {
        final double real = r.real;
        final double imag = r.imag;
        return <| {
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|2*j|>))] = real;
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|2*j+1|>))] = imag;
        } |>;
    }
    
    
    public final separable SafeCode<Void> setc64(complex64 r, final int i, final int j, final int k) {
        final double real = r.real;
        final double imag = r.imag;
        return <| {
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|2*k|>))] = real;
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|2*k+1|>))] = imag;
        } |>;
    }
    
    public final separable SafeCode<Void> setc64(complex64 r, final int i, final int j, final int k, final int l) {
        final double real = r.real;
        final double imag = r.imag;
        return <| {
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|2*l|>))] = real;
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|2*l+1|>))] = imag;
        } |>;
    }
    
    public final separable SafeCode<Void> setc64(complex64 r, final int i, final int j, final int k, final int l, final int m) {
        final double real = r.real;
        final double imag = r.imag;
        return <| {
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|2*m|>))] = real;
            `(baseArray)[`(offset) + `(region.ordinal(<|i|>,<|j|>,<|k|>,<|l|>,<|2*m+1|>))] = imag;
        } |>;
    }
}
