package hj.array.view.test;

import hj.lang.*;
import hj.array.*;
import hj.array.view.*;

import edu.rice.cs.mint.runtime.*;

import junit.framework.*;

public class SComplexDoubleArrayViewTest extends TestCase {
    public static double[] fba = new double[] { 1.0, 2.0 };
    public static void main(String[] args) {
// NOTE: the array is accessed via CSP
//        final double[] ba = new double[] { 1.0, 2.0 };
//        final SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0 }, 0));
// NOTE: not CSP, but recreates the array every time it is used
//        final SafeCode<double[]> cba = <| new double[] { 1.0, 2.0 } |>;
//        final SComplexDoubleArrayView v = new SComplexDoubleArrayView(cba, 0, new SRegionRectangular(new int[] { 0, 0 }, 0));
        final SComplexDoubleArrayView v = new SComplexDoubleArrayView(<| fba |>, 0, new SRegionRectangular(new int[] { 0, 0 }, 0));
        Code<Double> cd = <| `(v.get(0)) + `(v.get(1)) |>;
        System.out.println(cd.run());
    }
    public void testSingleton() {
        final double[] ba = new double[2];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        assertEquals(1.0, v.get(0).run());
        assertEquals(2.0, v.get(1).run());
        <| { `(v.set(3.0, 0)); 
            `(v.set(4.0, 1)); } |>.run();
        assertEquals(3.0, ba[0]);
        assertEquals(4.0, ba[1]);
    }
    
    public void test1by1() {
        final double[] ba = new double[2];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0, 0, 0 }, 0)); // 1x1
        ba[0] = 1.0;
        ba[1] = 2.0;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(2.0, v.get(0, 1).run());
        <| { `(v.set(3.0, 0, 0));
            `(v.set(4.0, 0, 1)); } |>.run();
        assertEquals(3.0, ba[0]);
        assertEquals(4.0, ba[1]);
    }
    
    public void test2by1() {
        final double[] ba = new double[4];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(2.0, v.get(0, 1).run());
        assertEquals(3.0, v.get(1, 0).run());
        assertEquals(4.0, v.get(1, 1).run());
        <| { `(v.set(5.0, 0, 0));
            `(v.set(6.0, 0, 1));
            `(v.set(7.0, 1, 0));
            `(v.set(8.0, 1, 1)); } |>.run();
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
        assertEquals(7.0, ba[2]);
        assertEquals(8.0, ba[3]);
    }
    
    public void test1by2() {
        final double[] ba = new double[4];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 2.0;
        ba[2] = 3.0;
        ba[3] = 4.0;
        
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(2.0, v.get(0, 1).run());
        assertEquals(3.0, v.get(0, 2).run());
        assertEquals(4.0, v.get(0, 3).run());
        <| { `(v.set(5.0, 0, 0));
            `(v.set(6.0, 0, 1));
            `(v.set(7.0, 0, 2));
            `(v.set(8.0, 0, 3)); } |>.run();
        assertEquals(5.0, ba[0]);
        assertEquals(6.0, ba[1]);
        assertEquals(7.0, ba[2]);
        assertEquals(8.0, ba[3]);
    }
    
    
    public void test3by1() {
        final double[] ba = new double[6];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(1, 0).run());
        assertEquals(2.1, v.get(1, 1).run());
        assertEquals(3.0, v.get(2, 0).run());
        assertEquals(3.1, v.get(2, 1).run());
        <| { `(v.set(5.0, 0, 0));
            `(v.set(6.0, 1, 0));
            `(v.set(7.0, 2, 0));
            `(v.set(5.1, 0, 1));
            `(v.set(6.1, 1, 1));
            `(v.set(7.1, 2, 1)); } |>.run();
        assertEquals(5.0, ba[0]);
        assertEquals(5.1, ba[1]);
        assertEquals(6.0, ba[2]);
        assertEquals(6.1, ba[3]);
        assertEquals(7.0, ba[4]);
        assertEquals(7.1, ba[5]);
    }
    
    public void test1by3() {
        final double[] ba = new double[6];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0, 0, 2 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(0, 2).run());
        assertEquals(2.1, v.get(0, 3).run());
        assertEquals(3.0, v.get(0, 4).run());
        assertEquals(3.1, v.get(0, 5).run());
        
        <| { `(v.set(5.0, 0, 0));
            `(v.set(5.1, 0, 1));
            `(v.set(6.0, 0, 2));
            `(v.set(6.1, 0, 3));
            `(v.set(7.0, 0, 4));
            `(v.set(7.1, 0, 5)); } |>.run();
        assertEquals(5.0, ba[0]);
        assertEquals(5.1, ba[1]);
        assertEquals(6.0, ba[2]);
        assertEquals(6.1, ba[3]);
        assertEquals(7.0, ba[4]);
        assertEquals(7.1, ba[5]);
    }

    public void test3by2() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 2, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(0, 2).run());
        assertEquals(2.1, v.get(0, 3).run());
        assertEquals(3.0, v.get(1, 0).run());
        assertEquals(3.1, v.get(1, 1).run());
        assertEquals(4.0, v.get(1, 2).run());
        assertEquals(4.1, v.get(1, 3).run());
        assertEquals(5.0, v.get(2, 0).run());
        assertEquals(5.1, v.get(2, 1).run());
        assertEquals(6.0, v.get(2, 2).run());
        assertEquals(6.1, v.get(2, 3).run());
        
        <| { `(v.set(1.2, 0, 0));
            `(v.set(1.3, 0, 1));
            `(v.set(2.2, 0, 2));
            `(v.set(2.3, 0, 3));
            `(v.set(3.2, 1, 0));
            `(v.set(3.3, 1, 1));
            `(v.set(4.2, 1, 2));
            `(v.set(4.3, 1, 3));
            `(v.set(5.2, 2, 0));
            `(v.set(5.3, 2, 1));
            `(v.set(6.2, 2, 2));
            `(v.set(6.3, 2, 3)); } |>.run();
        assertEquals(1.2, ba[0]);
        assertEquals(1.3, ba[1]);
        assertEquals(2.2, ba[2]);
        assertEquals(2.3, ba[3]);
        assertEquals(3.2, ba[4]);
        assertEquals(3.3, ba[5]);
        assertEquals(4.2, ba[6]);
        assertEquals(4.3, ba[7]);
        assertEquals(5.2, ba[8]);
        assertEquals(5.3, ba[9]);
        assertEquals(6.2, ba[10]);
        assertEquals(6.3, ba[11]);
    }

    public void test3by1viewOf3x2() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(1, 0).run());
        assertEquals(2.1, v.get(1, 1).run());
        assertEquals(3.0, v.get(2, 0).run());
        assertEquals(3.1, v.get(2, 1).run());
        
        <| { `(v.set(5.0, 0, 0));
            `(v.set(5.1, 0, 1));
            `(v.set(7.0, 1, 0));
            `(v.set(7.1, 1, 1));
            `(v.set(9.0, 2, 0));
            `(v.set(9.1, 2, 1)); } |>.run();
        assertEquals(5.0, ba[0]);
        assertEquals(5.1, ba[1]);
        assertEquals(7.0, ba[2]);
        assertEquals(7.1, ba[3]);
        assertEquals(9.0, ba[4]);
        assertEquals(9.1, ba[5]);
    }
    
    public void test3by1viewOf3x2b() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 3, new SRegionRectangular(new int[] { 0, 2, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(4.0, v.get(0, 0).run());
        assertEquals(4.1, v.get(0, 1).run());
        assertEquals(5.0, v.get(1, 0).run());
        assertEquals(5.1, v.get(1, 1).run());
        assertEquals(6.0, v.get(2, 0).run());
        assertEquals(6.1, v.get(2, 1).run());
        
        <| { `(v.set(5.2, 0, 0));
            `(v.set(5.3, 0, 1));
            `(v.set(7.2, 1, 0));
            `(v.set(7.3, 1, 1));
            `(v.set(9.2, 2, 0));
            `(v.set(9.3, 2, 1)); } |>.run();
        assertEquals(5.2, ba[6]);
        assertEquals(5.3, ba[7]);
        assertEquals(7.2, ba[8]);
        assertEquals(7.3, ba[9]);
        assertEquals(9.2, ba[10]);
        assertEquals(9.3, ba[11]);
    }

    public void test1by2viewOf3x2() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(0, 2).run());
        assertEquals(2.1, v.get(0, 3).run());
        
        <| { `(v.set(1.2, 0, 0));
            `(v.set(1.3, 0, 1));
            `(v.set(2.2, 0, 2));
            `(v.set(2.3, 0, 3)); } |>.run();
        assertEquals(1.2, ba[0]);
        assertEquals(1.3, ba[1]);
        assertEquals(2.2, ba[2]);
        assertEquals(2.3, ba[3]);
    }
    
    public void test1by2viewOf3x2b() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 2, new SRegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        
        assertEquals(3.0, v.get(0, 0).run());
        assertEquals(3.1, v.get(0, 1).run());
        assertEquals(4.0, v.get(0, 2).run());
        assertEquals(4.1, v.get(0, 3).run());
        
        <| { `(v.set(3.2, 0, 0));
            `(v.set(3.3, 0, 1));
            `(v.set(4.2, 0, 2));
            `(v.set(4.3, 0, 3)); } |>.run();
        assertEquals(3.2, ba[4]);
        assertEquals(3.3, ba[5]);
        assertEquals(4.2, ba[6]);
        assertEquals(4.3, ba[7]);
    }

    public void test1by2viewOf3x2c() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 4, new SRegionRectangular(new int[] { 0, 0, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        
        assertEquals(5.0, v.get(0, 0).run());
        assertEquals(5.1, v.get(0, 1).run());
        assertEquals(6.0, v.get(0, 2).run());
        assertEquals(6.1, v.get(0, 3).run());
        
        <| {`(v.set(5.2, 0, 0));
            `(v.set(5.3, 0, 1));
            `(v.set(6.2, 0, 2));
            `(v.set(6.3, 0, 3)); } |>.run();
        assertEquals(5.2, ba[8]);
        assertEquals(5.3, ba[9]);
        assertEquals(6.2, ba[10]);
        assertEquals(6.3, ba[11]);
    }
    
    public void test2by2viewOf3x2() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 1, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(0, 2).run());
        assertEquals(2.1, v.get(0, 3).run());
        assertEquals(3.0, v.get(1, 0).run());
        assertEquals(3.1, v.get(1, 1).run());
        assertEquals(4.0, v.get(1, 2).run());
        assertEquals(4.1, v.get(1, 3).run());
        
        <| {`(v.set(1.2, 0, 0));
            `(v.set(1.3, 0, 1));
            `(v.set(2.2, 0, 2));
            `(v.set(2.3, 0, 3));
            `(v.set(3.2, 1, 0));
            `(v.set(3.3, 1, 1));
            `(v.set(4.2, 1, 2));
            `(v.set(4.3, 1, 3)); } |>.run();
        assertEquals(1.2, ba[0]);
        assertEquals(1.3, ba[1]);
        assertEquals(2.2, ba[2]);
        assertEquals(2.3, ba[3]);
        assertEquals(3.2, ba[4]);
        assertEquals(3.3, ba[5]);
        assertEquals(4.2, ba[6]);
        assertEquals(4.3, ba[7]);
    }

    public void test2by2viewOf3x2b() {
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 2, new SRegionRectangular(new int[] { 0, 1, 0, 1 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        
        assertEquals(3.0, v.get(0, 0).run());
        assertEquals(3.1, v.get(0, 1).run());
        assertEquals(4.0, v.get(0, 2).run());
        assertEquals(4.1, v.get(0, 3).run());
        assertEquals(5.0, v.get(1, 0).run());
        assertEquals(5.1, v.get(1, 1).run());
        assertEquals(6.0, v.get(1, 2).run());
        assertEquals(6.1, v.get(1, 3).run());
        
        <| {`(v.set(3.2, 0, 0));
            `(v.set(3.3, 0, 1));
            `(v.set(4.2, 0, 2));
            `(v.set(4.3, 0, 3));
            `(v.set(5.2, 1, 0));
            `(v.set(5.3, 1, 1));
            `(v.set(6.2, 1, 2));
            `(v.set(6.3, 1, 3)); } |>.run();;
        assertEquals(3.2, ba[4]);
        assertEquals(3.3, ba[5]);
        assertEquals(4.2, ba[6]);
        assertEquals(4.3, ba[7]);
        assertEquals(5.2, ba[8]);
        assertEquals(5.3, ba[9]);
        assertEquals(6.2, ba[10]);
        assertEquals(6.3, ba[11]);
    }

    public void test2by1viewOf3x2() {
        // |12|3
        // |..|.
        //  45 6
        //  .. .
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 0, new SRegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(1.0, v.get(0, 0).run());
        assertEquals(1.1, v.get(0, 1).run());
        assertEquals(2.0, v.get(1, 0).run());
        assertEquals(2.1, v.get(1, 1).run());
        
        <| {`(v.set(1.2, 0, 0));
            `(v.set(1.3, 0, 1));
            `(v.set(2.2, 1, 0));
            `(v.set(2.3, 1, 1)); } |>.run();
        assertEquals(1.2, ba[0]);
        assertEquals(1.3, ba[1]);
        assertEquals(2.2, ba[2]);
        assertEquals(2.3, ba[3]);
    }

    public void test2by1viewOf3x2b() {
        // 1|23|
        // .|..|
        // 4 56
        // . ..
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 1, new SRegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(2.0, v.get(0, 0).run());
        assertEquals(2.1, v.get(0, 1).run());
        assertEquals(3.0, v.get(1, 0).run());
        assertEquals(3.1, v.get(1, 1).run());
        
        <| {`(v.set(2.2, 0, 0));
            `(v.set(2.3, 0, 1));
            `(v.set(3.2, 1, 0));
            `(v.set(3.3, 1, 1)); } |>.run();
        assertEquals(2.2, ba[2]);
        assertEquals(2.3, ba[3]);
        assertEquals(3.2, ba[4]);
        assertEquals(3.3, ba[5]);
    }

    public void test2by1viewOf3x2c() {
        //  12 3
        //  .. .
        // |45|6
        // |..|.
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 3, new SRegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(4.0, v.get(0, 0).run());
        assertEquals(4.1, v.get(0, 1).run());
        assertEquals(5.0, v.get(1, 0).run());
        assertEquals(5.1, v.get(1, 1).run());
        
        <| {`(v.set(4.2, 0, 0));
            `(v.set(4.3, 0, 1));
            `(v.set(5.2, 1, 0));
            `(v.set(5.3, 1, 1)); } |>.run();
        assertEquals(4.2, ba[6]);
        assertEquals(4.3, ba[7]);
        assertEquals(5.2, ba[8]);
        assertEquals(5.3, ba[9]);
    }
    
    public void test2by1viewOf3x2d() {
        // 1 23
        // . ..
        // 4|56|
        // .|..|
        final double[] ba = new double[12];
        SComplexDoubleArrayView v = new SComplexDoubleArrayView(<|ba|>, 4, new SRegionRectangular(new int[] { 0, 1, 0, 0 }, 0));
        ba[0] = 1.0;
        ba[1] = 1.1;
        ba[2] = 2.0;
        ba[3] = 2.1;
        ba[4] = 3.0;
        ba[5] = 3.1;
        ba[6] = 4.0;
        ba[7] = 4.1;
        ba[8] = 5.0;
        ba[9] = 5.1;
        ba[10] = 6.0;
        ba[11] = 6.1;
        assertEquals(5.0, v.get(0, 0).run());
        assertEquals(5.1, v.get(0, 1).run());
        assertEquals(6.0, v.get(1, 0).run());
        assertEquals(6.1, v.get(1, 1).run());
        
        <| {`(v.set(5.2, 0, 0));
            `(v.set(5.3, 0, 1));
            `(v.set(6.2, 1, 0));
            `(v.set(6.3, 1, 1)); } |>.run();
        assertEquals(5.2, ba[8]);
        assertEquals(5.3, ba[9]);
        assertEquals(6.2, ba[10]);
        assertEquals(6.3, ba[11]);
    }
}