package hj.lang;

import hj.array.SRegionRectangular;
import edu.rice.cs.mint.runtime.*;

public abstract class SArrayView  {
    public final int rank;
    public final int base;
    public static final String propertyNames$ = " rank base offset ";
    
    
    /**
     * The offset from where to start index computation on the base array;
     */
    public final SafeCode<Integer> offset;
    public final SRegionRectangular region;
    
    public SArrayView(final int o, SRegionRectangular rectRegion) {
        this.offset = <|o|>;
        
        // Throws an exception if user didn't provide a RectangularRegion
        this.region = (SRegionRectangular) rectRegion;
        
        // initialize dep-type
        this.rank = rectRegion.rank;
        this.base = rectRegion.base;
        if (o < 0) {
            throw new Error("ArrayView offset must be positive");
        }
    }
    
    public final separable SafeCode<Integer> getDimensionSize(int dimension) {
        return region.getDimensionSize(dimension);
    }
    
    public separable SafeCode<Integer> getRowOffset(final int i) {
        //compute new offset
        return region.ordinal(<|i|>, region.clow_J);
    }
    
    public separable SafeCode<Integer> getRowOffset(final int i, final int j) {
        //compute new offset
        return region.ordinal(<|i|>, <|j|>, region.clow_K);
    }
}
